/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBDatabase;
import com.oceanbase.tools.dbbrowser.model.DBIndexAlgorithm;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBObjectWarningDescriptor;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.parser.SqlParser;
import com.oceanbase.tools.dbbrowser.parser.result.ParseSqlResult;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.mysql.MySQLNoGreaterThan5740SchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

public class OBMySQLSchemaAccessor
extends MySQLNoGreaterThan5740SchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLSchemaAccessor.class);
    protected static final Set<String> ESCAPE_SCHEMA_SET = new HashSet<String>(3);

    @Override
    public List<String> showDatabases() {
        return super.showDatabases().stream().filter(database -> !ESCAPE_SCHEMA_SET.contains(database)).collect(Collectors.toList());
    }

    public OBMySQLSchemaAccessor(JdbcOperations jdbcOperations) {
        super(jdbcOperations);
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/obmysql/obmysql_4_0_x.yaml");
    }

    @Override
    public DBDatabase getDatabase(String schemaName) {
        DBDatabase database = new DBDatabase();
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select object_name, timestamp from oceanbase.DBA_OBJECTS where object_type = 'DATABASE' and object_name = ").value(schemaName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            String objectName = rs.getString("object_name");
            String timestamp = rs.getString("timestamp");
            database.setName(objectName);
            database.setId(objectName + "_" + timestamp);
        });
        String sql = "SELECT DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata where SCHEMA_NAME ='" + schemaName + "'";
        this.jdbcOperations.query(sql, rs -> {
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
        });
        return database;
    }

    @Override
    public List<DBDatabase> listDatabases() {
        String sql = "SELECT SCHEMA_NAME, DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata;";
        return this.jdbcOperations.query(sql, (rs, num) -> {
            DBDatabase database = new DBDatabase();
            database.setId(rs.getString("SCHEMA_NAME"));
            database.setName(rs.getString("SCHEMA_NAME"));
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
            return database;
        }).stream().filter(database -> !ESCAPE_SCHEMA_SET.contains(database.getName())).collect(Collectors.toList());
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        List<DBObjectIdentity> results = super.listTables(schemaName, tableNameLike);
        String querySystemTable = "show full tables from oceanbase where Table_type='BASE TABLE'";
        try {
            List tables = this.jdbcOperations.query(querySystemTable, (rs, rowNum) -> rs.getString(1));
            tables.forEach(name -> results.add(DBObjectIdentity.of("oceanbase", DBObjectType.TABLE, name)));
        }
        catch (Exception e) {
            log.warn("List system tables from 'oceanbase' failed, reason={}", (Object)e.getMessage());
        }
        return results;
    }

    @Override
    public List<DBObjectIdentity> listAllSystemViews() {
        List<DBObjectIdentity> results = super.listAllSystemViews();
        String sql1 = "show full tables from `oceanbase` where Table_type='SYSTEM VIEW'";
        try {
            List oceanbaseViews = this.jdbcOperations.query(sql1, (rs, rowNum) -> rs.getString(1));
            oceanbaseViews.forEach(name -> results.add(DBObjectIdentity.of("oceanbase", DBObjectType.VIEW, name)));
        }
        catch (Exception ex) {
            log.info("List tables for 'oceanbase' failed, reason={}", (Object)ex.getMessage());
        }
        return results;
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        List<DBTableColumn> columns = super.listTableColumns(schemaName, tableName);
        this.setStoredColumnByDDL(schemaName, tableName, columns);
        return columns;
    }

    @Override
    public Map<String, List<DBTableColumn>> listTableColumns(String schemaName) {
        Map<String, List<DBTableColumn>> tableName2Columns = super.listTableColumns(schemaName);
        tableName2Columns.forEach((tableName, columns) -> this.setStoredColumnByDDL(schemaName, (String)tableName, (List<DBTableColumn>)columns));
        return tableName2Columns;
    }

    protected void setStoredColumnByDDL(String schemeName, String tableName, List<DBTableColumn> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return;
        }
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("show create table ");
            sb.schemaPrefixIfNotBlank(schemeName);
            sb.identifier(tableName);
            List ddl = this.jdbcOperations.query(sb.toString(), (rs, num) -> rs.getString(2));
            if (CollectionUtils.isEmpty((Collection)ddl) || StringUtils.isBlank((CharSequence)((CharSequence)ddl.get(0)))) {
                this.fillWarning(columns, DBObjectType.COLUMN, "get table DDL failed");
            } else {
                ParseSqlResult result = SqlParser.parseMysql((String)ddl.get(0));
                if (CollectionUtils.isEmpty(result.getColumns())) {
                    this.fillWarning(columns, DBObjectType.COLUMN, "parse DDL failed, may view object");
                } else {
                    columns.forEach(column -> result.getColumns().forEach(columnDefinition -> {
                        if (StringUtils.equals((CharSequence)column.getName(), (CharSequence)columnDefinition.getName())) {
                            column.setStored(columnDefinition.getIsStored());
                        }
                    }));
                }
            }
        }
        catch (Exception e) {
            this.fillWarning(columns, DBObjectType.COLUMN, "query ddl failed");
            log.warn("Fetch table ddl for parsing column failed", (Throwable)e);
        }
    }

    @Override
    public List<DBTableIndex> listTableIndexes(String schemaName, String tableName) {
        List<DBTableIndex> indexList = super.listTableIndexes(schemaName, tableName);
        this.fillIndexRange(indexList, schemaName, tableName);
        for (DBTableIndex index : indexList) {
            if (index.getAlgorithm() != DBIndexAlgorithm.UNKNOWN) continue;
            index.setAlgorithm(DBIndexAlgorithm.BTREE);
        }
        return indexList;
    }

    @Override
    protected void handleIndexAvailability(DBTableIndex index, String availability) {
        if ("available".equals(availability)) {
            index.setAvailable(true);
        } else if ("unavailable".equals(availability)) {
            index.setAvailable(false);
        }
    }

    @Override
    public Map<String, List<DBTableIndex>> listTableIndexes(String schemaName) {
        Map<String, List<DBTableIndex>> tableName2Indexes = super.listTableIndexes(schemaName);
        for (Map.Entry<String, List<DBTableIndex>> entry : tableName2Indexes.entrySet()) {
            this.fillIndexRange(entry.getValue(), schemaName, entry.getKey());
            for (DBTableIndex index : entry.getValue()) {
                if (index.getAlgorithm() != DBIndexAlgorithm.UNKNOWN) continue;
                index.setAlgorithm(DBIndexAlgorithm.BTREE);
            }
        }
        return tableName2Indexes;
    }

    @Override
    protected boolean isIndexDistinguishesVisibility() {
        return true;
    }

    protected void fillIndexRange(List<DBTableIndex> indexList, String schemaName, String tableName) {
        this.setIndexRangeByDDL(indexList, schemaName, tableName);
    }

    protected void setIndexRangeByDDL(List<DBTableIndex> indexList, String schemaName, String tableName) {
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("show create table ");
            sb.identifier(schemaName, tableName);
            List ddl = this.jdbcOperations.query(sb.toString(), (rs, num) -> rs.getString(2));
            if (CollectionUtils.isEmpty((Collection)ddl) || StringUtils.isBlank((CharSequence)((CharSequence)ddl.get(0)))) {
                this.fillWarning(indexList, DBObjectType.INDEX, "get index DDL failed");
            } else {
                ParseSqlResult result = SqlParser.parseMysql((String)ddl.get(0));
                if (CollectionUtils.isEmpty(result.getIndexes())) {
                    this.fillWarning(indexList, DBObjectType.INDEX, "parse index DDL failed");
                } else {
                    indexList.forEach(index -> result.getIndexes().forEach(dbIndex -> {
                        if (StringUtils.equals((CharSequence)index.getName(), (CharSequence)dbIndex.getName())) {
                            index.setGlobal("GLOBAL".equalsIgnoreCase(dbIndex.getRange().name()));
                        }
                    }));
                }
            }
        }
        catch (Exception e) {
            this.fillWarning(indexList, DBObjectType.INDEX, "query index ddl failed");
            log.warn("Fetch table index through ddl parsing failed", (Throwable)e);
        }
    }

    protected <T extends DBObjectWarningDescriptor> void fillWarning(List<T> warningDescriptor, DBObjectType type, String reason) {
        if (CollectionUtils.isEmpty(warningDescriptor)) {
            return;
        }
        warningDescriptor.forEach(descriptor -> {
            if (StringUtils.isBlank((CharSequence)descriptor.getWarning())) {
                DBSchemaAccessorUtil.fillWarning(descriptor, type, reason);
            }
        });
    }

    @Override
    public List<DBObjectIdentity> listSequences(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW SEQUENCES IN ").identifier(schemaName);
        List sequenceNames = this.jdbcOperations.queryForList(sb.toString(), String.class);
        return sequenceNames.stream().map(name -> DBObjectIdentity.of(schemaName, DBObjectType.SEQUENCE, name)).collect(Collectors.toList());
    }

    static {
        ESCAPE_SCHEMA_SET.add("PUBLIC");
        ESCAPE_SCHEMA_SET.add("LBACSYS");
        ESCAPE_SCHEMA_SET.add("ORAAUDITOR");
        ESCAPE_SCHEMA_SET.add("__public");
    }
}

