/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.oracle;

import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBSynonymType;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.oracle.OBOracleSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.OracleDataDictTableNames;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class OBOracleLessThan400SchemaAccessor
extends OBOracleSchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBOracleLessThan400SchemaAccessor.class);

    public OBOracleLessThan400SchemaAccessor(JdbcOperations jdbcOperations, OracleDataDictTableNames dataDictTableNames) {
        super(jdbcOperations, dataDictTableNames);
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/oboracle/oboracle_3_x.yaml");
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select\n  t1.DATABASE_NAME as schema_name,\n  t2.TABLE_NAME as name,\n  'TABLE' as type \nfrom \n  SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT t1,\n  SYS.ALL_VIRTUAL_TABLE_REAL_AGENT t2\nwhere \n  t1.database_id=t2.database_id\n  and t2.table_type = 3\n");
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            sb.append("  and t1.database_name = ").value(schemaName);
        }
        if (StringUtils.isNotBlank((CharSequence)tableNameLike)) {
            sb.append("  and t2.table_name LIKE ").value(tableNameLike);
        }
        sb.append(" order by t1.database_name, t2.table_name");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBObjectIdentity.class));
    }

    @Override
    public DBTable.DBTableOptions getTableOptions(String schemaName, String tableName) {
        DBTable.DBTableOptions tableOptions = new DBTable.DBTableOptions();
        this.obtainTableCharset(tableOptions);
        this.obtainTableCollation(tableOptions);
        String sql = this.sqlMapper.getSql("get-table-option");
        try {
            this.jdbcOperations.query(sql.toString(), new Object[]{schemaName, tableName}, rs -> {
                tableOptions.setCreateTime(rs.getTimestamp("GMT_CREATE"));
                tableOptions.setUpdateTime(rs.getTimestamp("GMT_MODIFIED"));
                tableOptions.setComment(rs.getString("COMMENT"));
                tableOptions.setTabletSize(rs.getLong("TABLET_SIZE"));
            });
        }
        catch (Exception ex) {
            log.warn("get table options failed, schema={}, table={}, reason:", new Object[]{schemaName, tableName, ex});
        }
        return tableOptions;
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        partition.setPartitionOption(new DBTablePartitionOption());
        partition.setPartitionDefinitions(new ArrayList<DBTablePartitionDefinition>());
        String sql = this.sqlMapper.getSql("get-partition");
        try {
            this.jdbcOperations.query(sql.toString(), new Object[]{schemaName, tableName}, rs -> {
                DBTablePartitionOption option = partition.getPartitionOption();
                option.setType(DBTablePartitionType.fromValue(rs.getString("PARTITION_METHOD")));
                option.setPartitionsNum(rs.getInt("PART_NUM"));
                String expression = rs.getString("EXPRESSION");
                if (option.getType().supportExpression()) {
                    option.setExpression(expression);
                } else {
                    option.setColumnNames(Arrays.asList(expression.split(",")));
                }
                DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
                partitionDefinition.setName(rs.getString("PART_NAME"));
                partitionDefinition.setOrdinalPosition(rs.getInt("PART_ID"));
                partitionDefinition.setType(option.getType());
                String maxValue = rs.getString("MAX_VALUE");
                String listValue = rs.getString("LIST_VALUE");
                partitionDefinition.fillValues(StringUtils.isNotEmpty((CharSequence)maxValue) ? maxValue : listValue);
                partition.getPartitionDefinitions().add(partitionDefinition);
            });
        }
        catch (Exception ex) {
            log.warn("get table partitions failed, schema={}, table={}, reason:", new Object[]{schemaName, tableName, ex});
        }
        return partition;
    }

    @Override
    protected String getSynonymOwnerSymbol(DBSynonymType synonymType, String schemaName) {
        if (synonymType.equals((Object)DBSynonymType.PUBLIC)) {
            return "PUBLIC";
        }
        if (synonymType.equals((Object)DBSynonymType.COMMON)) {
            return schemaName;
        }
        throw new UnsupportedOperationException("Not supported Synonym type");
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicTableColumns(String schemaName) {
        String sql = this.sqlMapper.getSql("list-basic-schema-table-columns");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName}, this.listBasicColumnsRowMapper());
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicViewColumns(String schemaName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select view_name from all_views where owner = ").value(schemaName);
        List viewNames = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString("view_name"));
        ArrayList<DBTableColumn> columns = new ArrayList<DBTableColumn>();
        for (String viewName : viewNames) {
            columns.addAll(this.fillViewColumnInfoByDesc(schemaName, viewName));
        }
        return columns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public List<DBTableColumn> listBasicViewColumns(String schemaName, String viewName) {
        return this.fillViewColumnInfoByDesc(schemaName, viewName);
    }

    protected List<DBTableColumn> fillViewColumnInfoByDesc(String schemaName, String viewName) {
        List<DBTableColumn> columns = new ArrayList<DBTableColumn>();
        try {
            OracleSqlBuilder sb = new OracleSqlBuilder();
            sb.append("desc ");
            if (StringUtils.isNotBlank((CharSequence)schemaName)) {
                sb.identifier(schemaName).append(".");
            }
            sb.identifier(viewName);
            columns = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> {
                DBTableColumn column = new DBTableColumn();
                column.setSchemaName(schemaName);
                column.setTableName(viewName);
                column.setName(rs.getString(1));
                column.setTypeName(rs.getString(2).split("\\(")[0]);
                return column;
            });
        }
        catch (Exception e) {
            log.warn("fail to get view column info, message={}", (Object)e.getMessage());
        }
        return columns;
    }
}

