/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.oracle;

import com.oceanbase.tools.dbbrowser.model.DBBasicPLObject;
import com.oceanbase.tools.dbbrowser.model.DBColumnTypeDisplay;
import com.oceanbase.tools.dbbrowser.model.DBDatabase;
import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBIndexAlgorithm;
import com.oceanbase.tools.dbbrowser.model.DBIndexType;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBPackage;
import com.oceanbase.tools.dbbrowser.model.DBPackageBasicInfo;
import com.oceanbase.tools.dbbrowser.model.DBPackageDetail;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.model.DBSequence;
import com.oceanbase.tools.dbbrowser.model.DBSynonym;
import com.oceanbase.tools.dbbrowser.model.DBSynonymType;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTrigger;
import com.oceanbase.tools.dbbrowser.model.DBType;
import com.oceanbase.tools.dbbrowser.model.DBTypeCode;
import com.oceanbase.tools.dbbrowser.model.DBView;
import com.oceanbase.tools.dbbrowser.model.datatype.DataTypeUtil;
import com.oceanbase.tools.dbbrowser.parser.PLParser;
import com.oceanbase.tools.dbbrowser.parser.SqlParser;
import com.oceanbase.tools.dbbrowser.parser.result.ParseOraclePLResult;
import com.oceanbase.tools.dbbrowser.parser.result.ParseSqlResult;
import com.oceanbase.tools.dbbrowser.schema.oracle.OracleSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.OracleDataDictTableNames;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.PLObjectErrMsgUtils;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class OBOracleSchemaAccessor
extends OracleSchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBOracleSchemaAccessor.class);

    public OBOracleSchemaAccessor(JdbcOperations jdbcOperations, OracleDataDictTableNames dataDictTableNames) {
        super(jdbcOperations, dataDictTableNames);
    }

    @Override
    public DBDatabase getDatabase(String schemaName) {
        DBDatabase database = new DBDatabase();
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("SELECT USERNAME, USERID from ").append(this.dataDictTableNames.USERS()).append(" WHERE USERNAME = ").value(schemaName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            database.setId(rs.getString("USERID"));
            database.setName(rs.getString("USERNAME"));
        });
        String sql = "select value from v$nls_parameters where PARAMETER = 'NLS_CHARACTERSET'";
        this.jdbcOperations.query(sql, rs -> database.setCharset(rs.getString(1)));
        sql = "SELECT value from v$nls_parameters where parameter = 'NLS_SORT'";
        this.jdbcOperations.query(sql, rs -> database.setCollation(rs.getString(1)));
        return database;
    }

    @Override
    public List<DBDatabase> listDatabases() {
        ArrayList databases = new ArrayList();
        String sql = "SELECT USERNAME from " + this.dataDictTableNames.USERS();
        this.jdbcOperations.query(sql, rs -> {
            DBDatabase database = new DBDatabase();
            String userName = rs.getString("USERNAME");
            database.setId(userName);
            database.setName(userName);
            databases.add(database);
        });
        sql = "select value from v$nls_parameters where PARAMETER = 'NLS_CHARACTERSET'";
        AtomicReference charset = new AtomicReference();
        this.jdbcOperations.query(sql, rs -> charset.set(rs.getString(1)));
        sql = "SELECT value from v$nls_parameters where parameter = 'NLS_SORT'";
        AtomicReference collation = new AtomicReference();
        this.jdbcOperations.query(sql, rs -> collation.set(rs.getString(1)));
        databases.forEach(item -> {
            item.setCharset((String)charset.get());
            item.setCollation((String)collation.get());
        });
        return databases.stream().filter(database -> !ESCAPE_USER_SET.contains(database.getName())).collect(Collectors.toList());
    }

    @Override
    public List<DBTableIndex> listTableIndexes(String schemaName, String tableName) {
        List<DBTableIndex> indexList = super.listTableIndexes(schemaName, tableName);
        this.fillIndexRange(indexList);
        for (DBTableIndex index : indexList) {
            if (index.getType() == DBIndexType.UNKNOWN) {
                if (index.isNonUnique()) {
                    index.setType(DBIndexType.NORMAL);
                } else {
                    index.setType(DBIndexType.UNIQUE);
                }
            }
            if (index.getAlgorithm() != DBIndexAlgorithm.UNKNOWN) continue;
            index.setAlgorithm(DBIndexAlgorithm.BTREE);
        }
        return indexList;
    }

    protected void fillIndexRange(List<DBTableIndex> indexList) {
        for (DBTableIndex index : indexList) {
            try {
                OracleSqlBuilder sb = new OracleSqlBuilder();
                sb.append("SELECT dbms_metadata.get_ddl('INDEX', ").value(index.getName()).append(", ").value(index.getOwner()).append(") DDL from dual");
                this.jdbcOperations.query(sb.toString(), (rs, num) -> {
                    String indexDdl = rs.getString("DDL");
                    ParseSqlResult result = SqlParser.parseOracle(indexDdl);
                    if (CollectionUtils.isEmpty(result.getIndexes())) {
                        DBSchemaAccessorUtil.fillWarning(index, index.type(), "parse index DDL failed");
                        index.setGlobal(true);
                    } else {
                        index.setGlobal("GLOBAL".equalsIgnoreCase(result.getIndexes().get(0).getRange().name()));
                    }
                    return indexDdl;
                });
            }
            catch (Exception ex) {
                DBSchemaAccessorUtil.fillWarning(index, index.type(), "failed to call dbms_metadata.get_ddl to get index ddl, may index of the primary key");
                log.warn("failed to call dbms_metadata.get_ddl to get index ddl, schema={}, indexName={}", new Object[]{index.getOwner(), index.getName(), ex});
                index.setGlobal(true);
            }
        }
    }

    @Override
    protected RowMapper listColumnsRowMapper() {
        int[] hiddenColumnOrdinaryPosition = new int[]{-1};
        return (rs, romNum) -> {
            DBTableColumn tableColumn = new DBTableColumn();
            tableColumn.setSchemaName(rs.getString("OWNER"));
            tableColumn.setTableName(rs.getString("TABLE_NAME"));
            tableColumn.setName(rs.getString("COLUMN_NAME"));
            tableColumn.setTypeName(DBSchemaAccessorUtil.normalizeTypeName(rs.getString("DATA_TYPE")));
            tableColumn.setFullTypeName(rs.getString("DATA_TYPE"));
            tableColumn.setCharUsed(DBTableColumn.CharUnit.fromString(rs.getString("CHAR_USED")));
            tableColumn.setOrdinalPosition(rs.getInt("COLUMN_ID"));
            tableColumn.setTypeModifiers(Arrays.asList(rs.getString("DATA_TYPE_MOD")));
            tableColumn.setMaxLength(rs.getLong(tableColumn.getCharUsed() == DBTableColumn.CharUnit.CHAR ? "CHAR_LENGTH" : "DATA_LENGTH"));
            tableColumn.setNullable("Y".equalsIgnoreCase(rs.getString("NULLABLE")));
            DBColumnTypeDisplay columnTypeDisplay = DBColumnTypeDisplay.fromName(tableColumn.getTypeName());
            if (columnTypeDisplay.displayScale()) {
                tableColumn.setScale(rs.getInt("DATA_SCALE"));
            }
            if (columnTypeDisplay.displayPrecision()) {
                if (Objects.nonNull(rs.getObject("DATA_PRECISION"))) {
                    tableColumn.setPrecision(rs.getLong("DATA_PRECISION"));
                } else {
                    tableColumn.setPrecision(tableColumn.getMaxLength());
                }
            }
            if ("NUMBER".equalsIgnoreCase(tableColumn.getTypeName())) {
                if (Objects.isNull(rs.getObject("DATA_SCALE"))) {
                    tableColumn.setScale(null);
                }
                if (Objects.isNull(rs.getObject("DATA_PRECISION"))) {
                    tableColumn.setPrecision(null);
                }
            }
            if (!columnTypeDisplay.displayPrecision() && !columnTypeDisplay.displayScale()) {
                if ("INTERVAL YEAR TO MONTH".equalsIgnoreCase(tableColumn.getTypeName())) {
                    tableColumn.setYearPrecision(rs.getInt("DATA_SCALE"));
                } else if ("INTERVAL DAY TO SECOND".equalsIgnoreCase(tableColumn.getTypeName())) {
                    int packedScale = rs.getInt("DATA_SCALE");
                    tableColumn.setDayPrecision(packedScale / 10);
                    tableColumn.setSecondPrecision(packedScale % 10);
                } else if (tableColumn.getTypeName().startsWith("TIMESTAMP")) {
                    tableColumn.setSecondPrecision(rs.getInt("DATA_SCALE"));
                }
            }
            tableColumn.setHidden("YES".equalsIgnoreCase(rs.getString("HIDDEN_COLUMN")));
            if (tableColumn.getHidden().booleanValue()) {
                tableColumn.setOrdinalPosition(hiddenColumnOrdinaryPosition[0]);
                hiddenColumnOrdinaryPosition[0] = hiddenColumnOrdinaryPosition[0] - 1;
            }
            tableColumn.setVirtual("YES".equalsIgnoreCase(rs.getString("VIRTUAL_COLUMN")));
            tableColumn.setDefaultValue("NULL".equals(rs.getString("DATA_DEFAULT")) ? null : rs.getString("DATA_DEFAULT"));
            if (tableColumn.getVirtual().booleanValue()) {
                tableColumn.setGenExpression(rs.getString("DATA_DEFAULT"));
            }
            return tableColumn;
        };
    }

    @Override
    public List<DBPLObjectIdentity> listFunctions(String schemaName) {
        List<DBPLObjectIdentity> functions = super.listFunctions(schemaName);
        Map<String, String> errorText = PLObjectErrMsgUtils.acquireErrorMessage(this.jdbcOperations, schemaName, DBObjectType.FUNCTION.name(), null);
        for (DBPLObjectIdentity function : functions) {
            if (!StringUtils.containsIgnoreCase((CharSequence)function.getStatus(), (CharSequence)"INVALID")) continue;
            function.setErrorMessage(errorText.get(function.getName()));
        }
        return functions;
    }

    @Override
    public List<DBPLObjectIdentity> listProcedures(String schemaName) {
        List<DBPLObjectIdentity> procedures = super.listProcedures(schemaName);
        Map<String, String> errorText = PLObjectErrMsgUtils.acquireErrorMessage(this.jdbcOperations, schemaName, DBObjectType.PROCEDURE.name(), null);
        for (DBPLObjectIdentity procedure : procedures) {
            if (!StringUtils.containsIgnoreCase((CharSequence)procedure.getStatus(), (CharSequence)"INVALID")) continue;
            procedure.setErrorMessage(errorText.get(procedure.getName()));
        }
        return procedures;
    }

    @Override
    public List<DBPLObjectIdentity> listPackages(String schemaName) {
        List<DBPLObjectIdentity> packages = super.listPackages(schemaName);
        ArrayList<DBPLObjectIdentity> filtered = new ArrayList<DBPLObjectIdentity>();
        HashMap<String, String> name2Status = new HashMap<String, String>();
        for (DBPLObjectIdentity dbPackage : packages) {
            String pkgName = dbPackage.getName();
            String status = dbPackage.getStatus();
            if (name2Status.containsKey(pkgName)) {
                if (!"INVALID".equalsIgnoreCase(status)) continue;
                name2Status.put(pkgName, status);
                continue;
            }
            name2Status.put(pkgName, status);
        }
        Map<String, String> errorText = PLObjectErrMsgUtils.acquireErrorMessage(this.jdbcOperations, schemaName, DBObjectType.PACKAGE.name(), null);
        String pkgName = null;
        for (DBPLObjectIdentity pkg : packages) {
            if (!Objects.isNull(pkgName) && StringUtils.equals((CharSequence)pkgName, (CharSequence)pkg.getName())) continue;
            pkgName = pkg.getName();
            DBPLObjectIdentity dbPackage = new DBPLObjectIdentity();
            dbPackage.setName(pkg.getName());
            dbPackage.setStatus((String)name2Status.get(pkg.getName()));
            dbPackage.setSchemaName(pkg.getSchemaName());
            dbPackage.setType(pkg.getType());
            if (StringUtils.containsIgnoreCase((CharSequence)dbPackage.getStatus(), (CharSequence)"INVALID")) {
                dbPackage.setErrorMessage(errorText.get(dbPackage.getName()));
            }
            filtered.add(dbPackage);
        }
        return filtered;
    }

    @Override
    public DBFunction getFunction(String schemaName, String functionName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select s.* , o.created, o.last_ddl_time, o.status from");
        sb.append(" (select * from ");
        sb.append(this.dataDictTableNames.OBJECTS());
        sb.append(" where object_type='FUNCTION') o right join ");
        sb.append(this.dataDictTableNames.SOURCE());
        sb.append(" s on s.name = o.object_name and s.owner = o.owner and s.type = o.object_type");
        sb.append(" where s.owner=");
        sb.value(schemaName);
        sb.append(" and s.name=");
        sb.value(functionName);
        sb.append(" and s.type = 'FUNCTION'");
        DBFunction function = new DBFunction();
        function.setFunName(functionName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            function.setDefiner(rs.getString(1));
            function.setDdl(String.format("CREATE OR REPLACE %s;", rs.getClob(5).toString()));
            function.setStatus(rs.getString(9));
            function.setCreateTime(Timestamp.valueOf(rs.getString(7)));
            function.setModifyTime(Timestamp.valueOf(rs.getString(8)));
        });
        if (StringUtils.containsIgnoreCase((CharSequence)function.getStatus(), (CharSequence)"INVALID")) {
            function.setErrorMessage(PLObjectErrMsgUtils.getOraclePLObjErrMsg(this.jdbcOperations, function.getDefiner(), DBObjectType.FUNCTION.name(), function.getFunName()));
        }
        return this.parseFunctionDDL(function);
    }

    private DBFunction parseFunctionDDL(DBFunction function) {
        try {
            ParseOraclePLResult result = PLParser.parseObOracle(function.getDdl());
            List<DBFunction> functionList = result.getFunctionList();
            if (functionList.size() > 0) {
                List<DBPLParam> params = functionList.get(0).getParams();
                for (DBPLParam param : params) {
                    param.setExtendedType(DataTypeUtil.isExtType(param.getDataType()));
                    param.setDefaultValue(StringUtils.unquoteSqlIdentifier(param.getDefaultValue(), '\''));
                }
                function.setParams(params);
            }
            function.setVariables(result.getVaribaleList());
            function.setTypes(result.getTypeList());
            function.setReturnType(result.getReturnType());
            if (DataTypeUtil.isExtType(result.getReturnType())) {
                function.setReturnExtendedType(true);
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse function ddl={}, errorMessage={}", (Object)function.getDdl(), (Object)e.getMessage());
            function.setParseErrorMessage(e.getMessage());
        }
        return function;
    }

    @Override
    public DBView getView(String schemaName, String viewName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select * from ");
        sb.append(this.dataDictTableNames.VIEWS());
        sb.append(" where owner =");
        sb.value(schemaName);
        sb.append(" and view_name =");
        sb.value(viewName);
        DBView view = new DBView();
        view.setViewName(viewName);
        view.setSchemaName(schemaName);
        AtomicReference partDdl = new AtomicReference();
        this.jdbcOperations.query(sb.toString(), rs -> {
            view.setDefiner(rs.getString("OWNER"));
            partDdl.set(rs.getClob("TEXT").toString());
        });
        boolean updatable = this.fillOracleUpdatableInfo(view);
        String ddl = String.format("CREATE VIEW %s AS %s", StringUtils.quoteOracleIdentifier(viewName), partDdl);
        if (!updatable && !ddl.toUpperCase().contains("WITH READ ONLY")) {
            view.setDdl(ddl + " WITH READ ONLY");
        } else {
            view.setDdl(ddl);
        }
        return this.fillColumnInfoByDesc(view);
    }

    private boolean fillOracleUpdatableInfo(DBView view) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select VIEW_IS_UPDATABLE from SYS.ALL_VIRTUAL_TABLE_REAL_AGENT where table_type = 4 and table_name =");
        sb.value(view.getViewName());
        sb.append(" and database_id = ");
        sb.append("(select database_id from SYS.ALL_VIRTUAL_DATABASE_REAL_AGENT where database_name = ");
        sb.value(view.getDefiner());
        sb.append(")");
        this.jdbcOperations.query(sb.toString(), rs -> {
            if (rs.getBigDecimal("VIEW_IS_UPDATABLE").intValue() == 0) {
                view.setCheckOption("READ_ONLY");
                view.setUpdatable(false);
            } else {
                view.setCheckOption("NONE");
                view.setUpdatable(true);
            }
        });
        return view.isUpdatable();
    }

    private DBView fillColumnInfoByDesc(DBView view) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("desc ");
        sb.identifier(view.getViewName());
        List columns = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> {
            DBTableColumn column = new DBTableColumn();
            column.setName(rs.getString("FIELD"));
            column.setTypeName(rs.getString("TYPE"));
            column.setNullable("YES".equalsIgnoreCase(rs.getString("NULL")));
            column.setDefaultValue(rs.getString("DEFAULT"));
            column.setOrdinalPosition(rowNum);
            column.setTableName(view.getViewName());
            return column;
        });
        view.setColumns(columns);
        return view;
    }

    @Override
    public DBProcedure getProcedure(String schemaName, String procedureName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select s.* , o.created, o.last_ddl_time, o.status from  (select * from ");
        sb.append(this.dataDictTableNames.OBJECTS());
        sb.append(" where object_type='PROCEDURE') o right join ");
        sb.append(this.dataDictTableNames.SOURCE());
        sb.append(" s on s.name = o.object_name and s.owner = o.owner and s.type = o.object_type where s.owner=");
        sb.value(schemaName);
        sb.append(" and s.name=");
        sb.value(procedureName);
        sb.append(" and s.type = 'PROCEDURE'");
        DBProcedure procedure = new DBProcedure();
        procedure.setProName(procedureName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            procedure.setDefiner(rs.getString("OWNER"));
            procedure.setDdl(String.format("create or replace %s;", rs.getClob("TEXT").toString()));
            procedure.setStatus(rs.getString("STATUS"));
            procedure.setCreateTime(rs.getTimestamp("CREATED"));
            procedure.setModifyTime(rs.getTimestamp("LAST_DDL_TIME"));
        });
        if (StringUtils.containsIgnoreCase((CharSequence)procedure.getStatus(), (CharSequence)"INVALID")) {
            procedure.setErrorMessage(PLObjectErrMsgUtils.getOraclePLObjErrMsg(this.jdbcOperations, procedure.getDefiner(), DBObjectType.PROCEDURE.name(), procedure.getProName()));
        }
        return this.parseProcedureDDL(procedure);
    }

    private DBProcedure parseProcedureDDL(DBProcedure procedure) {
        ParseOraclePLResult result;
        Validate.notBlank((CharSequence)procedure.getDdl(), (String)"procedure.ddl", (Object[])new Object[0]);
        String ddl = procedure.getDdl();
        try {
            result = PLParser.parseOracle(ddl);
        }
        catch (Exception e) {
            log.warn("Failed to parse, ddl={}, errorMessage={}", (Object)ddl, (Object)e.getMessage());
            procedure.setParseErrorMessage(e.getMessage());
            return procedure;
        }
        List<DBProcedure> procedureList = result.getProcedureList();
        if (procedureList.size() > 0) {
            List<DBPLParam> params = procedureList.get(0).getParams();
            for (DBPLParam param : params) {
                param.setExtendedType(DataTypeUtil.isExtType(param.getDataType()));
                param.setDefaultValue(StringUtils.unquoteSqlIdentifier(param.getDefaultValue(), '\''));
            }
            procedure.setParams(params);
        }
        procedure.setVariables(result.getVaribaleList());
        procedure.setTypes(result.getTypeList());
        return procedure;
    }

    @Override
    public DBPackage getPackage(String schemaName, String packageName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select s.* , o.created, o.last_ddl_time, o.status from (select * from ");
        sb.append(this.dataDictTableNames.OBJECTS());
        sb.append(" where object_type='PACKAGE' or object_type='PACKAGE BODY') o right join ");
        sb.append(this.dataDictTableNames.SOURCE());
        sb.append(" s on s.name = o.object_name and s.owner = o.owner and s.type = o.object_type where s.owner=");
        sb.value(schemaName);
        sb.append(" and s.name=");
        sb.value(packageName);
        DBPackage dbPackage = new DBPackage();
        dbPackage.setPackageName(packageName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            try {
                dbPackage.setStatus(rs.getString("STATUS"));
                DBPackageDetail packageDetail = new DBPackageDetail();
                DBPackageBasicInfo basicInfo = new DBPackageBasicInfo();
                basicInfo.setDdl("create or replace " + rs.getClob("TEXT").toString());
                basicInfo.setDefiner(rs.getString("OWNER"));
                basicInfo.setCreateTime(rs.getTimestamp("CREATED"));
                basicInfo.setModifyTime(rs.getTimestamp("LAST_DDL_TIME"));
                packageDetail.setBasicInfo(basicInfo);
                try {
                    ParseOraclePLResult oraclePLResult = PLParser.parseOracle(basicInfo.getDdl());
                    packageDetail.setVariables(oraclePLResult.getVaribaleList());
                    packageDetail.setTypes(oraclePLResult.getTypeList());
                    List<DBFunction> functionList = oraclePLResult.getFunctionList();
                    for (DBFunction function : functionList) {
                        List<DBPLParam> params = function.getParams();
                        for (DBPLParam dbPLParam : params) {
                            dbPLParam.setExtendedType(DataTypeUtil.isExtType(dbPLParam.getDataType()));
                        }
                        if (!DataTypeUtil.isExtType(function.getReturnType())) continue;
                        function.setReturnExtendedType(true);
                    }
                    packageDetail.setFunctions(functionList);
                    List<DBProcedure> procedureList = oraclePLResult.getProcedureList();
                    for (DBProcedure procedure : procedureList) {
                        List<DBPLParam> params = procedure.getParams();
                        for (DBPLParam dbPLParam : params) {
                            dbPLParam.setExtendedType(DataTypeUtil.isExtType(dbPLParam.getDataType()));
                        }
                    }
                    packageDetail.setProcedures(procedureList);
                }
                catch (Exception e) {
                    log.warn("Failed to parse ddl={}, errorMessage={}", (Object)basicInfo.getDdl(), (Object)e.getMessage());
                    packageDetail.setParseErrorMessage(e.getMessage());
                }
                if (DBObjectType.PACKAGE.name().equalsIgnoreCase(rs.getString("TYPE"))) {
                    dbPackage.setPackageHead(packageDetail);
                } else {
                    dbPackage.setPackageBody(packageDetail);
                }
            }
            catch (Exception e) {
                log.warn("Failed to parse, packageName={}, errorMessage={}", (Object)dbPackage.getPackageName(), (Object)e.getMessage());
            }
        });
        if (StringUtils.containsIgnoreCase((CharSequence)dbPackage.getStatus(), (CharSequence)"INVALID")) {
            dbPackage.setErrorMessage(PLObjectErrMsgUtils.getOraclePLObjErrMsg(this.jdbcOperations, schemaName, DBObjectType.PACKAGE.name(), dbPackage.getPackageName()));
        }
        return dbPackage;
    }

    @Override
    public List<DBPLObjectIdentity> listTriggers(String schemaName) {
        List<DBPLObjectIdentity> triggers = super.listTriggers(schemaName);
        Map<String, String> errorText = PLObjectErrMsgUtils.acquireErrorMessage(this.jdbcOperations, schemaName, DBObjectType.TRIGGER.name(), null);
        for (DBPLObjectIdentity trigger : triggers) {
            if (!StringUtils.containsIgnoreCase((CharSequence)trigger.getStatus(), (CharSequence)"INVALID")) continue;
            trigger.setErrorMessage(errorText.get(trigger.getName()));
        }
        return triggers;
    }

    @Override
    public List<DBPLObjectIdentity> listTypes(String schemaName) {
        List<DBPLObjectIdentity> types = super.listTypes(schemaName);
        Map<String, String> errorText = PLObjectErrMsgUtils.acquireErrorMessage(this.jdbcOperations, schemaName, DBObjectType.TYPE.name(), null);
        for (DBPLObjectIdentity type : types) {
            String errorMessage = errorText.get(type.getName());
            if (!StringUtils.isNotBlank((CharSequence)errorMessage)) continue;
            type.setStatus("INVALID");
            type.setErrorMessage(errorMessage);
        }
        return types;
    }

    @Override
    public DBTrigger getTrigger(String schemaName, String triggerName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select s.OWNER").append(",s.TRIGGER_NAME").append(",s.TRIGGER_TYPE").append(",s.TRIGGERING_EVENT").append(",s.TABLE_OWNER").append(",s.BASE_OBJECT_TYPE").append(",s.TABLE_NAME").append(",s.TABLE_NAME").append(",s.COLUMN_NAME").append(",s.REFERENCING_NAMES").append(",s.WHEN_CLAUSE").append(",s.STATUS as ENABLE_STATUS").append(",s.DESCRIPTION").append(",s.ACTION_TYPE").append(",s.TRIGGER_BODY").append(",s.CROSSEDITION").append(",s.BEFORE_STATEMENT").append(",s.BEFORE_ROW").append(",s.AFTER_ROW").append(",s.AFTER_STATEMENT").append(",s.INSTEAD_OF_ROW").append(",s.FIRE_ONCE").append(",s.APPLY_SERVER_ONLY").append(",o.STATUS").append(" FROM (SELECT * FROM ").append(this.dataDictTableNames.OBJECTS()).append(" WHERE OBJECT_TYPE='TRIGGER') o").append(" RIGHT JOIN ").append(this.dataDictTableNames.TRIGGERS()).append(" s ON o.OBJECT_NAME=s.TRIGGER_NAME AND o.OWNER=s.OWNER").append(" WHERE s.OWNER=").value(schemaName).append(" AND s.TRIGGER_NAME=").value(triggerName);
        Map map = (Map)this.jdbcOperations.queryForObject(sb.toString(), (rs, rowNum) -> {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashMap<String, String> map1 = new HashMap<String, String>();
            for (int i = 0; i < columnCount; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                if (columnLabel == null) {
                    throw new IllegalStateException("Column lable is null");
                }
                map1.putIfAbsent(columnLabel.toUpperCase(), rs.getString(i + 1));
            }
            return map1;
        });
        if (map == null) {
            throw new IllegalStateException("Failed to query trigger's meta info");
        }
        DBTrigger trigger = new DBTrigger();
        trigger.setBaseObjectType((String)map.get("BASE_OBJECT_TYPE"));
        trigger.setTriggerName((String)map.get("TRIGGER_NAME"));
        trigger.setOwner((String)map.get("OWNER"));
        trigger.setSchemaMode((String)map.get("TABLE_OWNER"));
        trigger.setSchemaName((String)map.get("TABLE_NAME"));
        trigger.setEnable("ENABLED".equalsIgnoreCase((String)map.get("ENABLE_STATUS")));
        trigger.setStatus((String)map.get("STATUS"));
        Validate.notNull((Object)trigger.getTriggerName(), (String)"TriggerName can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)trigger.getBaseObjectType(), (String)"BaseObjectType can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)trigger.getOwner(), (String)"Owner can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)trigger.getSchemaName(), (String)"TableName can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)trigger.getSchemaMode(), (String)"TableOwner can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)trigger.getStatus(), (String)"Status can not be null", (Object[])new Object[0]);
        String triggerBody = (String)map.get("TRIGGER_BODY");
        if (triggerBody != null) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)triggerBody, (CharSequence)"trigger")) {
                trigger.setDdl(String.format("CREATE OR REPLACE %s", triggerBody));
            } else {
                trigger.setDdl(this.fixDdlFromTrigger(trigger, triggerBody, (String)map.get("TRIGGERING_EVENT"), (String)map.get("TRIGGER_TYPE"), (String)map.get("REFERENCING_NAMES"), (String)map.get("WHEN_CLAUSE")));
            }
        }
        if (StringUtils.containsIgnoreCase((CharSequence)trigger.getStatus(), (CharSequence)"INVALID")) {
            trigger.setErrorMessage(PLObjectErrMsgUtils.getOraclePLObjErrMsg(this.jdbcOperations, trigger.getOwner(), DBObjectType.TRIGGER.name(), trigger.getTriggerName()));
        }
        return trigger;
    }

    protected String fixDdlFromTrigger(DBTrigger trigger, @NonNull String triggerBody, @NonNull String triggerEvent, @NonNull String triggerType, String referenceNames, String whenClause) {
        if (triggerBody == null) {
            throw new NullPointerException("triggerBody is marked non-null but is null");
        }
        if (triggerEvent == null) {
            throw new NullPointerException("triggerEvent is marked non-null but is null");
        }
        if (triggerType == null) {
            throw new NullPointerException("triggerType is marked non-null but is null");
        }
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE TRIGGER ").identifier(trigger.getOwner()).append(".").identifier(trigger.getTriggerName()).append(" ");
        String triggerMode = null;
        OracleSqlBuilder triggerLevel = null;
        if (StringUtils.startsWithIgnoreCase((CharSequence)triggerType, (CharSequence)"before") || StringUtils.startsWithIgnoreCase((CharSequence)triggerType, (CharSequence)"after")) {
            triggerLevel = new OracleSqlBuilder();
            String[] tmpStrList = triggerType.split(" ");
            triggerMode = tmpStrList[0];
            for (int i = 1; i < tmpStrList.length; ++i) {
                triggerLevel.append(tmpStrList[i]).append(" ");
            }
        }
        if (triggerMode != null) {
            sqlBuilder.append(triggerMode).append("\n\t");
        }
        sqlBuilder.append(triggerEvent).append(" ").append("ON ").identifier(trigger.getTableOwner()).append(".").identifier(trigger.getTableName()).append("\n\t");
        if (this.containsTriggerReferences()) {
            sqlBuilder.append(referenceNames).append("\n\t");
        }
        if (triggerLevel != null) {
            sqlBuilder.append("FOR ").append(triggerLevel.toString()).append("\n\t");
        }
        String status = trigger.getEnableState().substring(0, trigger.getEnableState().length() - 1);
        sqlBuilder.append(status).append("\n");
        if (StringUtils.isNotBlank((CharSequence)whenClause)) {
            sqlBuilder.append("\tWHEN (").append(whenClause).append(")\n");
        }
        return sqlBuilder.append(triggerBody).toString();
    }

    protected boolean containsTriggerReferences() {
        return true;
    }

    @Override
    public DBType getType(String schemaName, String typeName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select a.OWNER,a.OBJECT_NAME,u.TYPE_NAME,a.CREATED,a.LAST_DDL_TIME,u.TYPECODE,u.TYPEID from ");
        sb.append(this.dataDictTableNames.OBJECTS());
        sb.append(" a right join ");
        sb.append(this.dataDictTableNames.TYPES());
        sb.append(" u on a.OBJECT_NAME=u.TYPE_NAME where a.OWNER=");
        sb.value(schemaName);
        sb.append(" and u.TYPE_NAME=");
        sb.value(typeName);
        DBType type = new DBType();
        this.jdbcOperations.query(sb.toString(), rs -> {
            type.setOwner(rs.getString("OWNER"));
            type.setTypeName(rs.getString("TYPE_NAME"));
            type.setCreateTime(rs.getTimestamp("CREATED"));
            type.setLastDdlTime(rs.getTimestamp("LAST_DDL_TIME"));
            type.setTypeId(rs.getBigDecimal("TYPEID").toString());
            type.setType(rs.getString("TYPECODE"));
        });
        OracleSqlBuilder sb2 = new OracleSqlBuilder();
        sb2.append("select UPPER_BOUND from ALL_COLL_TYPES where TYPE_NAME=");
        sb2.value(typeName);
        Integer upperBound = (Integer)this.jdbcOperations.query(sb2.toString(), rs -> {
            if (!rs.next()) {
                return null;
            }
            return Integer.parseInt(rs.getBigDecimal(1).toString());
        });
        if (upperBound != null) {
            if (upperBound > 0) {
                type.setType(DBTypeCode.VARRAY.name());
            } else {
                type.setType(DBTypeCode.TABLE.name());
            }
        }
        return this.parseTypeDDL(type);
    }

    private DBType parseTypeDDL(DBType type) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select dbms_metadata.get_ddl('TYPE', ");
        sb.value(type.getTypeName());
        sb.append(", ");
        sb.value(type.getOwner());
        sb.append(") from dual");
        String typeDdl = (String)this.jdbcOperations.query(sb.toString(), rs -> {
            if (!rs.next()) {
                return null;
            }
            return rs.getClob(1).toString();
        });
        OracleSqlBuilder sb2 = new OracleSqlBuilder();
        sb2.append("select dbms_metadata.get_ddl('TYPE_SPEC', ");
        sb2.value(type.getTypeName());
        sb2.append(", ");
        sb2.value(type.getOwner());
        sb2.append(") from dual");
        String typeHeadDdl = (String)this.jdbcOperations.query(sb2.toString(), rs -> {
            if (!rs.next()) {
                return null;
            }
            return rs.getClob(1).toString();
        });
        Validate.notBlank((CharSequence)typeDdl, (String)"typeDdl", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)typeHeadDdl, (String)"typeHeadDdl", (Object[])new Object[0]);
        type.setDdl(typeDdl);
        DBBasicPLObject typeDetail = new DBBasicPLObject();
        try {
            ParseOraclePLResult oraclePLResult = PLParser.parseObOracle(typeHeadDdl);
            typeDetail.setVariables(oraclePLResult.getVaribaleList());
            typeDetail.setTypes(oraclePLResult.getTypeList());
            typeDetail.setProcedures(oraclePLResult.getProcedureList());
            typeDetail.setFunctions(oraclePLResult.getFunctionList());
        }
        catch (Exception e) {
            log.warn("Parse ddl failed, ddl={}, errorMessage={}", (Object)typeHeadDdl, (Object)e.getMessage());
            typeDetail.setParseErrorMessage(e.getMessage());
        }
        type.setTypeDetail(typeDetail);
        String errorText = PLObjectErrMsgUtils.getOraclePLObjErrMsg(this.jdbcOperations, type.getOwner(), DBObjectType.TYPE.name(), type.getTypeName());
        if (StringUtils.isNotBlank((CharSequence)errorText)) {
            type.setStatus("INVALID");
            type.setErrorMessage(errorText);
        }
        return type;
    }

    @Override
    public DBSequence getSequence(String schemaName, String sequenceName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select * from ");
        sb.append(this.dataDictTableNames.SEQUENCES());
        sb.append(" where sequence_owner=");
        sb.value(schemaName);
        sb.append(" and sequence_name=");
        sb.value(sequenceName);
        DBSequence sequence = new DBSequence();
        sequence.setName(sequenceName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            sequence.setUser(rs.getString("SEQUENCE_OWNER"));
            sequence.setMinValue(rs.getBigDecimal("MIN_VALUE").toString());
            sequence.setMaxValue(rs.getBigDecimal("MAX_VALUE").toString());
            sequence.setIncreament(rs.getBigDecimal("INCREMENT_BY").longValue());
            sequence.setCycled("Y".equalsIgnoreCase(rs.getString("CYCLE_FLAG")));
            sequence.setOrderd("Y".equalsIgnoreCase(rs.getString("ORDER_FLAG")));
            long cacheSize = rs.getBigDecimal("CACHE_SIZE").longValue();
            if (cacheSize > 1L) {
                sequence.setCacheSize(cacheSize);
                sequence.setCached(true);
            } else {
                sequence.setCached(false);
            }
            sequence.setNextCacheValue(rs.getBigDecimal("LAST_NUMBER").toString());
        });
        String ddl = this.fullfillSequenceDdl(sequence);
        sequence.setDdl(ddl);
        return sequence;
    }

    private String fullfillSequenceDdl(DBSequence sequence) {
        Validate.notNull((Object)sequence, (String)"sequence", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)sequence.getName(), (String)"sequence.name", (Object[])new Object[0]);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE SEQUENCE \"").append(StringUtils.escapeUseDouble(sequence.getName(), '\"')).append("\"");
        if (sequence.getMinValue() != null) {
            sqlBuilder.append(" MINVALUE ").append(sequence.getMinValue());
        } else {
            sqlBuilder.append(" NOMINVALUE");
        }
        if (sequence.getMaxValue() != null) {
            sqlBuilder.append(" MAXVALUE ").append(sequence.getMaxValue());
        } else {
            sqlBuilder.append(" NOMAXVALUE");
        }
        if (sequence.getStartValue() != null) {
            sqlBuilder.append(" START WITH ").append(sequence.getStartValue());
        }
        if (sequence.getIncreament() != null) {
            sqlBuilder.append(" INCREMENT BY ").append(sequence.getIncreament());
        }
        if (sequence.getCached() != null) {
            if (sequence.getCached().booleanValue() && sequence.getCacheSize() != null) {
                sqlBuilder.append(" CACHE ").append(sequence.getCacheSize());
            } else {
                sqlBuilder.append(" NOCACHE");
            }
        }
        if (sequence.getOrderd() != null) {
            if (sequence.getOrderd().booleanValue()) {
                sqlBuilder.append(" ORDER");
            } else {
                sqlBuilder.append(" NOORDER");
            }
        }
        if (sequence.getCycled() != null) {
            if (sequence.getCycled().booleanValue()) {
                sqlBuilder.append(" CYCLE");
            } else {
                sqlBuilder.append(" NOCYCLE");
            }
        }
        sqlBuilder.append(";");
        return sqlBuilder.toString();
    }

    @Override
    public List<DBObjectIdentity> listSynonyms(String schemaName, DBSynonymType synonymType) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select s.OWNER as schema_name, s.SYNONYM_NAME as name, o.OBJECT_TYPE as type from ");
        sb.append(this.dataDictTableNames.SYNONYMS());
        sb.append(" s left join (select * from ");
        sb.append(this.dataDictTableNames.OBJECTS());
        sb.append(" where OBJECT_TYPE='SYNONYM') o on s.SYNONYM_NAME=o.OBJECT_NAME and s.OWNER=o.OWNER where s.OWNER=");
        sb.value(this.getSynonymOwnerSymbol(synonymType, schemaName));
        sb.append(" order by name asc");
        return this.jdbcOperations.query(sb.toString(), (RowMapper)new BeanPropertyRowMapper(DBObjectIdentity.class));
    }

    @Override
    public DBSynonym getSynonym(String schemaName, @NotEmpty String synonymName, @NonNull DBSynonymType synonymType) {
        if (synonymType == null) {
            throw new NullPointerException("synonymType is marked non-null but is null");
        }
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select s.OWNER,s.SYNONYM_NAME,s.TABLE_OWNER,s.TABLE_NAME,s.DB_LINK,o.CREATED,o.LAST_DDL_TIME,o.STATUS from ");
        sb.append(this.dataDictTableNames.SYNONYMS());
        sb.append(" s left join (select * from ");
        sb.append(this.dataDictTableNames.OBJECTS());
        sb.append(" where OBJECT_TYPE='SYNONYM') o on s.SYNONYM_NAME=o.OBJECT_NAME and s.OWNER=o.OWNER where s.OWNER=");
        sb.value(this.getSynonymOwnerSymbol(synonymType, schemaName));
        sb.append(" and s.SYNONYM_NAME=");
        sb.value(synonymName);
        DBSynonym synonym = new DBSynonym();
        synonym.setSynonymType(synonymType);
        this.jdbcOperations.query(sb.toString(), rs -> {
            synonym.setOwner(rs.getString("OWNER"));
            synonym.setSynonymName(rs.getString("SYNONYM_NAME"));
            synonym.setTableOwner(rs.getString("TABLE_OWNER"));
            synonym.setTableName(rs.getString("TABLE_NAME"));
            synonym.setDbLink(rs.getString("DB_LINK"));
            synonym.setCreated(rs.getTimestamp("CREATED"));
            synonym.setLastDdlTime(rs.getTimestamp("LAST_DDL_TIME"));
            synonym.setStatus(rs.getString("STATUS"));
        });
        OracleSqlBuilder ddl = new OracleSqlBuilder();
        ddl.append("CREATE OR REPLACE ");
        if (synonymType == DBSynonymType.PUBLIC) {
            ddl.append("PUBLIC ");
        }
        ddl.append("SYNONYM ").identifier(synonym.getSynonymName()).append(" FOR ");
        if (StringUtils.isNotBlank((CharSequence)synonym.getTableOwner())) {
            ddl.identifier(synonym.getTableOwner()).append(".");
        }
        ddl.identifier(StringUtils.isBlank((CharSequence)synonym.getDbLink()) ? synonym.getTableName() : synonym.getTableName() + "@" + synonym.getDbLink()).append(";");
        synonym.setSynonymType(synonym.getSynonymType());
        synonym.setDdl(ddl.toString());
        return synonym;
    }

    protected String getSynonymOwnerSymbol(DBSynonymType synonymType, String schemaName) {
        if (synonymType.equals((Object)DBSynonymType.PUBLIC)) {
            return "__public";
        }
        if (synonymType.equals((Object)DBSynonymType.COMMON)) {
            return schemaName;
        }
        throw new UnsupportedOperationException("Not supported Synonym type");
    }
}

