/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.stats.mysql;

import com.oceanbase.tools.dbbrowser.model.DBSession;
import com.oceanbase.tools.dbbrowser.model.DBTableStats;
import com.oceanbase.tools.dbbrowser.stats.DBStatsAccessor;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class MySQLNoGreaterThan5740StatsAccessor
implements DBStatsAccessor {
    private static final String QUERY_SESSION_FROM_PROCESSLIST = "SELECT `ID`, `USER` as USERNAME, `DB` as DATABASE_NAME, `HOST`, `HOST` as PROXY_HOST, `TIME` as EXECUTE_TIME, COMMAND, STATE, 'UNKNOWN' AS `TRANS_STATE`, null AS `TRANS_ID`, null AS  `SQL_ID`, null AS  `TRACE_ID`, LEFT(`INFO`, 200) AS LATEST_QUERIES FROM   information_schema.PROCESSLIST ";
    private static final String QUERY_CURRENT_SESSION_FROM_PROCESSLIST = "SELECT `ID`, `USER` as USERNAME, `DB` as DATABASE_NAME, `HOST`, `HOST` as PROXY_HOST, `TIME` as EXECUTE_TIME, COMMAND, STATE, 'UNKNOWN' AS `TRANS_STATE`, null AS `TRANS_ID`, null AS  `SQL_ID`, null AS  `TRACE_ID`, LEFT(`INFO`, 200) AS LATEST_QUERIES FROM   information_schema.PROCESSLIST  WHERE `ID` = connection_id()";
    final JdbcOperations jdbcOperations;

    public MySQLNoGreaterThan5740StatsAccessor(@NonNull JdbcOperations jdbcOperations) {
        if (jdbcOperations == null) {
            throw new NullPointerException("jdbcOperations is marked non-null but is null");
        }
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public DBTableStats getTableStats(@NonNull String schema, @NonNull String tableName) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        String sql = this.sqlBuilder().append("select TABLE_ROWS, DATA_LENGTH from `information_schema`.`tables`").append(" where table_schema=").value(schema).append(" and table_name=").value(tableName).toString();
        DBTableStats stats = new DBTableStats();
        this.jdbcOperations.query(sql, t -> {
            stats.setRowCount(t.getLong("TABLE_ROWS"));
            stats.setDataSizeInBytes(t.getLong("DATA_LENGTH"));
        });
        return stats;
    }

    @Override
    public List<DBSession> listAllSessions() {
        return this.jdbcOperations.query(QUERY_SESSION_FROM_PROCESSLIST, (RowMapper)new BeanPropertyRowMapper(DBSession.class));
    }

    @Override
    public DBSession currentSession() {
        List sessions = this.jdbcOperations.query(QUERY_CURRENT_SESSION_FROM_PROCESSLIST, (RowMapper)new BeanPropertyRowMapper(DBSession.class));
        return CollectionUtils.isEmpty((Collection)sessions) ? DBSession.unknown() : (DBSession)sessions.get(0);
    }

    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }
}

