/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.oracle;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPLType;
import com.oceanbase.tools.dbbrowser.model.DBPackage;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.parser.PLParser;
import com.oceanbase.tools.dbbrowser.parser.result.ParseOraclePLResult;
import com.oceanbase.tools.dbbrowser.template.oracle.BaseOraclePLTemplate;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.jdbc.core.JdbcOperations;

public class OraclePackageTemplate
extends BaseOraclePLTemplate<DBPackage> {
    private static final Pattern PATTERN = Pattern.compile("((is|as)(\\s|\n|\r|\t)+|^)(type|subtype|cursor|function|procedure)", 2);
    private final JdbcOperations jdbcOperations;

    public OraclePackageTemplate(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public String generateCreateObjectTemplate(@NotNull DBPackage dbObject) {
        Validate.notNull((Object)dbObject.getPackageType(), (String)"Package type can not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbObject.getPackageName(), (String)"Package name can not be blank", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE ").append(dbObject.type().getName());
        if (DBObjectType.PACKAGE == dbObject.type()) {
            sqlBuilder.append(" ").identifier(dbObject.getPackageName()).append(" AS").append("\n\tFUNCTION FUNC_EXAMPLE (p1 IN NUMBER) RETURN NUMBER;").append("\n\tPROCEDURE PROC_EXAMPLE (p1 IN NUMBER);").append("\nEND");
            return sqlBuilder.toString();
        }
        String schema = (String)this.jdbcOperations.query("SELECT SYS_CONTEXT('userenv', 'CURRENT_SCHEMA') FROM DUAL", rs -> {
            if (!rs.next()) {
                throw new IllegalStateException("Empty result set");
            }
            return rs.getString(1);
        });
        OracleSqlBuilder queryBuilder = new OracleSqlBuilder();
        queryBuilder.append("SELECT TEXT FROM ALL_SOURCE WHERE OWNER=").value(schema).append(" AND NAME=").value(dbObject.getPackageName()).append(" AND TYPE='PACKAGE'");
        List textList = this.jdbcOperations.query(queryBuilder.toString(), (rs, rowNum) -> rs.getString(1));
        if (CollectionUtils.isEmpty((Collection)textList)) {
            throw new IllegalStateException("Package not found, " + schema + "." + dbObject.getPackageName());
        }
        String ddl = ((String)textList.get(0)).trim();
        if (!ddl.startsWith("create") && !ddl.startsWith("CREATE")) {
            ddl = "CREATE " + ddl;
        }
        return this.buildPackageBodyDdl(PLParser.parseOracle(ddl));
    }

    private String buildPackageBodyDdl(ParseOraclePLResult parseResult) {
        String isOrAs = parseResult.getIsOrAs();
        StringBuilder create = new StringBuilder("CREATE OR REPLACE PACKAGE BODY ");
        create.append(parseResult.getPlName()).append(" ").append(isOrAs).append("\n");
        for (DBFunction function : parseResult.getFunctionList()) {
            create.append("\n").append(function.getDdl()).append(" ").append(isOrAs).append("\nBEGIN\n\t-- TODO\nEND;\n");
        }
        for (DBProcedure procedure : parseResult.getProcedureList()) {
            create.append("\n").append(procedure.getDdl()).append(" ").append(isOrAs).append("\nBEGIN\n\t-- TODO\nEND;\n");
        }
        for (DBPLType cursor : parseResult.getCursorList()) {
            create.append("\n").append(cursor.getDdl()).append(" ").append(isOrAs).append("\nBEGIN\n\t-- TODO\nEND;\n");
        }
        create.append("\nEND ").append(parseResult.getPlName()).append(";");
        return create.toString();
    }
}

