/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.oracle;

import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBPLParamMode;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.template.oracle.BaseOraclePLTemplate;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class OracleProcedureTemplate
extends BaseOraclePLTemplate<DBProcedure> {
    @Override
    public String generateCreateObjectTemplate(@NotNull DBProcedure dbObject) {
        Validate.notBlank((CharSequence)dbObject.getProName(), (String)"Procedure name can not be blank", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE PROCEDURE ").identifier(dbObject.getProName());
        List<DBPLParam> paramList = dbObject.getParams();
        if (CollectionUtils.isNotEmpty(paramList)) {
            String params = paramList.stream().map(p -> {
                StringBuilder builder = new StringBuilder();
                DBPLParamMode type = p.getParamMode();
                String defaultValue = p.getDefaultValue();
                builder.append("\n\t").append(p.getParamName()).append(" ").append(this.generateInOutString(type)).append(" ").append(p.getDataType());
                if (StringUtils.isNotBlank((CharSequence)defaultValue) && DBPLParamMode.IN == type) {
                    builder.append(" DEFAULT ").append(StringUtils.quoteOracleValue(defaultValue));
                }
                return builder.toString();
            }).collect(Collectors.joining(","));
            sqlBuilder.append("(").append(params).append(")");
        }
        sqlBuilder.append(" IS").append("\nBEGIN").append("\n\t-- Enter your procedure code").append("\nEND");
        return sqlBuilder.toString();
    }
}

