/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.oracle;

import com.oceanbase.tools.dbbrowser.model.DBType;
import com.oceanbase.tools.dbbrowser.model.DBTypeCode;
import com.oceanbase.tools.dbbrowser.template.oracle.BaseOraclePLTemplate;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;

public class OracleTypeTemplate
extends BaseOraclePLTemplate<DBType> {
    @Override
    public String generateCreateObjectTemplate(@NotNull DBType dbObject) {
        Validate.notBlank((CharSequence)dbObject.getTypeName(), (String)"Type name can not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dbObject.getTypeCode()), (String)"Type code can not be null", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE TYPE ").identifier(dbObject.getTypeName());
        if (DBTypeCode.OBJECT == dbObject.getTypeCode()) {
            sqlBuilder.append("\nAS OBJECT").append("(/* TODO enter attribute and method declarations here */)");
        } else if (DBTypeCode.VARRAY == dbObject.getTypeCode()) {
            sqlBuilder.append("\nAS VARRAY").append("(/* array size */) OF /* datatype */");
        } else {
            sqlBuilder.append("\nAS TABLE OF /* datatype */");
        }
        return sqlBuilder.toString();
    }
}

