/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

public class PLObjectErrMsgUtils {
    private static final Logger log = LoggerFactory.getLogger(PLObjectErrMsgUtils.class);

    public static String getOraclePLObjErrMsg(JdbcOperations jdbcOperations, String owner, String objectType, String objectName) {
        return PLObjectErrMsgUtils.acquireErrorMessage(jdbcOperations, owner, objectType, objectName).getOrDefault(objectName, null);
    }

    public static Map<String, String> acquireErrorMessage(JdbcOperations jdbcOperations, String owner, String objectType, String objectName) {
        HashMap<String, String> objectName2Text = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)owner) || StringUtils.isEmpty((CharSequence)objectType)) {
            log.info("Skip acquire error message, owner={}, objectType={}, objectName={}", new Object[]{owner, objectType, objectName});
            return objectName2Text;
        }
        String sql = PLObjectErrMsgUtils.generateOracleQuerySql(owner, objectType, objectName);
        jdbcOperations.query(sql, resultSet -> {
            String name = resultSet.getString(1);
            String text = resultSet.getString(2);
            String lineStr = resultSet.getString(3);
            String positionStr = resultSet.getString(4);
            String errorMessage = PLObjectErrMsgUtils.generateErrorText(text, lineStr, positionStr);
            if (objectName2Text.containsKey(name)) {
                String originalValue = (String)objectName2Text.get(name);
                objectName2Text.put(name, originalValue + "\n" + errorMessage);
            } else {
                objectName2Text.put(name, errorMessage);
            }
        });
        return objectName2Text;
    }

    private static String generateOracleQuerySql(String owner, String objectType, String objectName) {
        String sql = DBObjectType.PACKAGE.name().equalsIgnoreCase(objectType) ? String.format("select /*+leading(O)*/ name, text, line, position from all_errors where owner = %s and (type = 'PACKAGE' or type = 'PACKAGE BODY')", StringUtils.quoteOracleValue(owner)) : String.format("select /*+leading(O)*/ name, text, line, position from all_errors where owner = %s and type = %s", StringUtils.quoteOracleValue(owner), StringUtils.quoteOracleValue(objectType));
        if (StringUtils.isNotBlank((CharSequence)objectName)) {
            sql = String.format("%s and name = %s", sql, StringUtils.quoteOracleValue(objectName));
        }
        return sql;
    }

    private static String generateErrorText(String text, String lineStr, String positionStr) {
        if (StringUtils.isBlank((CharSequence)lineStr) || StringUtils.isBlank((CharSequence)positionStr)) {
            return text;
        }
        return String.format("%s at line %s, position %s", text, lineStr, positionStr);
    }
}

