/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class DBTablePartitionEditor
implements DBObjectEditor<DBTablePartition> {
    @Override
    public boolean editable() {
        return false;
    }

    protected void appendExpression(DBTablePartition partition, SqlBuilder sqlBuilder) {
        String expression = partition.getPartitionOption().getExpression();
        List<String> columnNames = partition.getPartitionOption().getColumnNames();
        if (StringUtils.isNotEmpty((CharSequence)expression)) {
            sqlBuilder.append(expression);
        } else if (CollectionUtils.isNotEmpty(columnNames)) {
            List quotedColumnNames = columnNames.stream().map(columnName -> this.sqlBuilder().append((CharSequence)columnName).toString()).collect(Collectors.toList());
            sqlBuilder.append(String.join((CharSequence)",", quotedColumnNames));
        }
    }

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBTablePartition partition) {
        if (partition.getPartitionOption().getType() == null || partition.getPartitionOption().getType() == DBTablePartitionType.NOT_PARTITIONED) {
            return "";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append(" PARTITION BY ").append(partition.getPartitionOption().getType().getValue()).append("(");
        this.appendExpression(partition, sqlBuilder);
        sqlBuilder.append(") ");
        if (Objects.nonNull(partition.getSubpartitionTemplated()) && partition.getSubpartitionTemplated().booleanValue()) {
            this.generateCreateTemplateSubPartition(partition, sqlBuilder);
        }
        if (Objects.nonNull(partition.getPartitionOption().getPartitionsNum())) {
            sqlBuilder.append("\nPARTITIONS ").append(String.valueOf(partition.getPartitionOption().getPartitionsNum()));
            if (partition.getPartitionOption().getType() == DBTablePartitionType.HASH || partition.getPartitionOption().getType() == DBTablePartitionType.KEY) {
                return sqlBuilder.toString();
            }
        }
        this.appendDefinitions(partition, sqlBuilder);
        return sqlBuilder.toString();
    }

    protected void generateCreateTemplateSubPartition(DBTablePartition partition, SqlBuilder sqlBuilder) {
    }

    protected abstract void appendDefinitions(DBTablePartition var1, SqlBuilder var2);

    protected abstract void appendDefinition(DBTablePartitionOption var1, DBTablePartitionDefinition var2, SqlBuilder var3);

    @Override
    public String generateUpdateObjectDDL(@NotNull DBTablePartition oldPartition, @NotNull DBTablePartition newPartition) {
        if (Objects.isNull(oldPartition) || Objects.isNull(newPartition)) {
            return "";
        }
        if (oldPartition.getPartitionOption().getType() != newPartition.getPartitionOption().getType()) {
            return this.handleUpdatePartitionType(oldPartition, newPartition);
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        String fullyQualifiedTableName = this.getFullyQualifiedTableName(newPartition);
        List<DBTablePartitionDefinition> oldDefinitions = oldPartition.getPartitionDefinitions();
        List<DBTablePartitionDefinition> newDefinitions = newPartition.getPartitionDefinitions();
        if (CollectionUtils.isEmpty(oldDefinitions)) {
            if (CollectionUtils.isNotEmpty(newDefinitions)) {
                newDefinitions.forEach(definition -> sqlBuilder.append(this.generateAddPartitionDefinitionDDL((DBTablePartitionDefinition)definition, newPartition.getPartitionOption(), fullyQualifiedTableName)));
            }
            return sqlBuilder.toString();
        }
        if (CollectionUtils.isEmpty(newDefinitions)) {
            if (CollectionUtils.isNotEmpty(oldDefinitions)) {
                oldDefinitions.forEach(definition -> sqlBuilder.append(this.generateDropPartitionDefinitionDDL((DBTablePartitionDefinition)definition, fullyQualifiedTableName)));
            }
            return sqlBuilder.toString();
        }
        HashMap position2NewPartition = new HashMap();
        newDefinitions.forEach(newDefinition -> {
            if (Objects.nonNull(newDefinition.getOrdinalPosition())) {
                position2NewPartition.put(newDefinition.getOrdinalPosition(), newDefinition);
            }
        });
        for (DBTablePartitionDefinition newDefinition2 : newDefinitions) {
            if (!Objects.isNull(newDefinition2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateAddPartitionDefinitionDDL(newDefinition2, newPartition.getPartitionOption(), fullyQualifiedTableName));
        }
        for (DBTablePartitionDefinition oldDefinition : oldDefinitions) {
            if (position2NewPartition.containsKey(oldDefinition.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateDropPartitionDefinitionDDL(oldDefinition, fullyQualifiedTableName));
        }
        return sqlBuilder.toString();
    }

    private String handleUpdatePartitionType(@NotNull DBTablePartition oldPartition, @NotNull DBTablePartition newPartition) {
        DBTablePartitionType newType;
        DBTablePartitionType oldType = oldPartition.getPartitionOption().getType();
        Validate.isTrue((oldType != (newType = newPartition.getPartitionOption().getType()) ? 1 : 0) != 0, (String)"Partition type should be different", (Object[])new Object[0]);
        if (newType == DBTablePartitionType.NOT_PARTITIONED) {
            return this.generateDropObjectDDL(oldPartition);
        }
        if (oldType == DBTablePartitionType.NOT_PARTITIONED) {
            return this.generateCreateObjectDDL(newPartition);
        }
        return this.modifyPartitionType(oldPartition, newPartition);
    }

    protected abstract String modifyPartitionType(@NotNull DBTablePartition var1, @NotNull DBTablePartition var2);

    @Override
    public String generateUpdateObjectListDDL(Collection<DBTablePartition> oldObjects, Collection<DBTablePartition> newObjects) {
        if (CollectionUtils.isEmpty(oldObjects) || CollectionUtils.isEmpty(newObjects)) {
            return "";
        }
        ArrayList<DBTablePartition> oldPartitions = new ArrayList<DBTablePartition>(oldObjects);
        ArrayList<DBTablePartition> newPartitions = new ArrayList<DBTablePartition>(newObjects);
        return this.generateUpdateObjectDDL((DBTablePartition)oldPartitions.get(0), (DBTablePartition)newPartitions.get(0));
    }

    public String generateShadowTableUpdateObjectDDL(@NotNull DBTablePartition oldPartition, @NotNull DBTablePartition newPartition) {
        if (Objects.isNull(oldPartition) || Objects.isNull(newPartition)) {
            return "";
        }
        if (oldPartition.getPartitionOption().getType() != newPartition.getPartitionOption().getType()) {
            return this.handleUpdatePartitionType(oldPartition, newPartition);
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        String fullyQualifiedTableName = this.getFullyQualifiedTableName(newPartition);
        List<DBTablePartitionDefinition> oldDefinitions = oldPartition.getPartitionDefinitions();
        List<DBTablePartitionDefinition> newDefinitions = newPartition.getPartitionDefinitions();
        if (CollectionUtils.isEmpty(oldDefinitions)) {
            if (CollectionUtils.isNotEmpty(newDefinitions)) {
                newDefinitions.forEach(definition -> sqlBuilder.append(this.generateAddPartitionDefinitionDDL((DBTablePartitionDefinition)definition, newPartition.getPartitionOption(), fullyQualifiedTableName)));
            }
            return sqlBuilder.toString();
        }
        if (CollectionUtils.isEmpty(newDefinitions)) {
            if (CollectionUtils.isNotEmpty(oldDefinitions)) {
                oldDefinitions.forEach(definition -> sqlBuilder.append(this.generateDropPartitionDefinitionDDL((DBTablePartitionDefinition)definition, fullyQualifiedTableName)));
            }
            return sqlBuilder.toString();
        }
        HashMap name2NewPartition = new HashMap();
        HashMap name2OldPartition = new HashMap();
        newDefinitions.forEach(newDefinition -> {
            if (Objects.nonNull(newDefinition.getName())) {
                name2NewPartition.put(newDefinition.getName(), newDefinition);
            }
        });
        oldDefinitions.forEach(oldDefinition -> {
            if (Objects.nonNull(oldDefinition.getName())) {
                name2OldPartition.put(oldDefinition.getName(), oldDefinition);
            }
        });
        for (DBTablePartitionDefinition newDefinition2 : newDefinitions) {
            if (name2OldPartition.containsKey(newDefinition2.getName())) continue;
            sqlBuilder.append(this.generateAddPartitionDefinitionDDL(newDefinition2, newPartition.getPartitionOption(), fullyQualifiedTableName));
        }
        for (DBTablePartitionDefinition oldDefinition2 : oldDefinitions) {
            if (name2NewPartition.containsKey(oldDefinition2.getName())) continue;
            sqlBuilder.append(this.generateDropPartitionDefinitionDDL(oldDefinition2, fullyQualifiedTableName));
        }
        return sqlBuilder.toString();
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTablePartition oldObject, @NotNull DBTablePartition newObject) {
        return "";
    }

    public String generateDropPartitionDefinitionDDL(@NotNull DBTablePartitionDefinition definition, String fullyQualifiedTableName) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(fullyQualifiedTableName).append(" DROP PARTITION (").append(definition.getName()).append(");").line();
        return sqlBuilder.toString();
    }

    public String generateDropPartitionDefinitionDDL(String schemaName, @NonNull String tableName, List<DBTablePartitionDefinition> definitions) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ");
        if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
            sqlBuilder.identifier(schemaName).append(".");
        }
        sqlBuilder.identifier(tableName).append(" DROP PARTITION (");
        Validate.isTrue((!CollectionUtils.isEmpty(definitions) ? 1 : 0) != 0, (String)"Partition elements can not be empty", (Object[])new Object[0]);
        return sqlBuilder.append(definitions.stream().map(d -> this.sqlBuilder().identifier(d.getName()).toString()).collect(Collectors.joining(", "))).append(");").line().toString();
    }

    public abstract String generateAddPartitionDefinitionDDL(@NotNull DBTablePartitionDefinition var1, @NotNull DBTablePartitionOption var2, String var3);

    public abstract String generateAddPartitionDefinitionDDL(String var1, @NonNull String var2, @NonNull DBTablePartitionOption var3, List<DBTablePartitionDefinition> var4);

    protected abstract SqlBuilder sqlBuilder();

    protected String getFullyQualifiedTableName(@NotNull DBTablePartition partition) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (StringUtils.isNotEmpty((CharSequence)partition.getSchemaName())) {
            sqlBuilder.identifier(partition.getSchemaName());
        }
        if (StringUtils.isNotEmpty((CharSequence)partition.getTableName())) {
            sqlBuilder.append(".").identifier(partition.getTableName());
        }
        return sqlBuilder.toString();
    }
}

