/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model.datatype.parser;

import com.oceanbase.tools.dbbrowser.model.datatype.parser.DataTypeToken;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class CommonDataTypeToken
implements Serializable,
DataTypeToken {
    private final int start;
    private final int stop;
    private final int type;
    private final String text;

    public CommonDataTypeToken(@NonNull String text, int start, int stop, int type) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        Validate.isTrue((start >= 0 ? 1 : 0) != 0, (String)"Start index can not be negative", (Object[])new Object[0]);
        Validate.isTrue((stop >= start ? 1 : 0) != 0, (String)"Stop index can not be smaller than start index", (Object[])new Object[0]);
        this.start = start;
        this.stop = stop;
        this.text = text;
        this.type = type;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getStartIndex() {
        return this.start;
    }

    @Override
    public int getStopIndex() {
        return this.stop;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String toString() {
        String txt = this.getText();
        if (txt != null) {
            txt = txt.replace("\n", "\\n");
            txt = txt.replace("\r", "\\r");
            txt = txt.replace("\t", "\\t");
        } else {
            txt = "<no text>";
        }
        String typeString = String.valueOf(this.type);
        return "[" + this.start + ":" + this.stop + "='" + txt + "',<" + typeString + ">]";
    }
}

