/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.result;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModePLParserListener;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModeParserListener;
import com.oceanbase.tools.dbbrowser.parser.result.ParsePLResult;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ParseOraclePLResult
extends ParsePLResult {
    private List<DBProcedure> procedureList;
    private List<DBFunction> functionList;

    public ParseOraclePLResult(OracleModePLParserListener listener) {
        super(listener);
        this.varibaleList = listener.getVaribaleList();
        this.typeList = listener.getTypeList();
        this.returnType = listener.getReturnType();
        this.plName = listener.getPlName();
        this.plType = listener.getPlType();
        this.isOrAs = listener.getIsOrAs();
        this.procedureList = listener.getProcedureList();
        this.functionList = listener.getFunctionList();
        this.cursorList = listener.getCursorList();
        this.empty = listener.isEmpty();
    }

    public ParseOraclePLResult(OracleModeParserListener listener) {
        super(listener);
        this.varibaleList = listener.getVaribaleList();
        this.typeList = listener.getTypeList();
        this.cursorList = listener.getCursorList();
        this.procedureList = listener.getProcedureList();
        this.functionList = listener.getFunctionList();
        this.cursorList = listener.getCursorList();
        this.plName = listener.getPlName();
        this.plType = listener.getPlType();
        this.isOrAs = listener.getIsOrAs();
    }

    public boolean containsFunction(String functionName) {
        if (StringUtils.isBlank((CharSequence)functionName)) {
            return false;
        }
        for (DBFunction function : this.functionList) {
            if (!function.getFunName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProcedure(String procedureName) {
        if (StringUtils.isBlank((CharSequence)procedureName)) {
            return false;
        }
        for (DBProcedure procedure : this.procedureList) {
            if (!procedure.getProName().equals(procedureName)) continue;
            return true;
        }
        return false;
    }

    public List<DBProcedure> getProcedureList() {
        return this.procedureList;
    }

    public List<DBFunction> getFunctionList() {
        return this.functionList;
    }

    public void setProcedureList(List<DBProcedure> procedureList) {
        this.procedureList = procedureList;
    }

    public void setFunctionList(List<DBFunction> functionList) {
        this.functionList = functionList;
    }
}

