/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class DBSchemaAccessorSqlMappers {
    private static final List<String> SQL_MAPPER_FILE_PATHS = new ArrayList<String>();
    private static final Map<String, DBSchemaAccessorSqlMapper> VERSION_2_SQL_MAPPERS = new HashMap<String, DBSchemaAccessorSqlMapper>();

    public static DBSchemaAccessorSqlMapper get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        DBSchemaAccessorSqlMapper mapper = VERSION_2_SQL_MAPPERS.get(key);
        if (mapper == null) {
            throw new NullPointerException("Failed to get mapper by " + key);
        }
        return mapper;
    }

    private static <T> T fromYaml(URL url, Class<T> classType) {
        if (url == null) {
            return null;
        }
        try {
            return (T)DBSchemaAccessorSqlMappers.yamlMapper().readValue(url, classType);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static ObjectMapper yamlMapper() {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        yamlMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy());
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return yamlMapper;
    }

    static {
        SQL_MAPPER_FILE_PATHS.addAll(Arrays.asList("schema/sql/obmysql/obmysql_4_0_x.yaml", "schema/sql/obmysql/obmysql_3_x.yaml", "schema/sql/obmysql/obmysql_2_2_76.yaml", "schema/sql/obmysql/obmysql_2_2_5x.yaml", "schema/sql/obmysql/obmysql_1_4_79.yaml", "schema/sql/mysql/mysql_5_7_x.yaml", "schema/sql/mysql/mysql_5_6_x.yaml", "schema/sql/oboracle/oboracle_3_x.yaml", "schema/sql/oboracle/oboracle_4_0_x.yaml", "schema/sql/oracle/oracle_11g.yaml"));
        for (String path : SQL_MAPPER_FILE_PATHS) {
            URL url = DBSchemaAccessorSqlMappers.class.getClassLoader().getResource(path);
            if (url == null) {
                throw new IllegalStateException("Failed to get url by path, " + path);
            }
            DBSchemaAccessorSqlMapper sqlMappers = DBSchemaAccessorSqlMappers.fromYaml(url, DBSchemaAccessorSqlMapper.class);
            VERSION_2_SQL_MAPPERS.putIfAbsent(path, sqlMappers);
        }
    }
}

