/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBDatabase;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.model.DBView;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.lang.NonNull;

public class OBMySQLBetween2277And3XSchemaAccessor
extends OBMySQLSchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLBetween2277And3XSchemaAccessor.class);
    protected final List<String> VIEW_AS_BASE_TABLE = Arrays.asList("time_zone", "time_zone_name", "time_zone_transition", "time_zone_transition_type");

    public OBMySQLBetween2277And3XSchemaAccessor(@NonNull JdbcOperations jdbcOperations) {
        super(jdbcOperations);
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/obmysql/obmysql_3_x.yaml");
    }

    @Override
    public DBDatabase getDatabase(String schemaName) {
        DBDatabase database = new DBDatabase();
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select database_id, database_name from oceanbase.gv$database where database_name=").value(schemaName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            database.setId(rs.getString("database_id"));
            database.setName(rs.getString("database_name"));
        });
        String sql = "SELECT DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata WHERE SCHEMA_NAME ='" + schemaName + "'";
        this.jdbcOperations.query(sql, rs -> {
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
        });
        return database;
    }

    @Override
    protected void fillIndexRange(List<DBTableIndex> indexList, String schemaName, String tableName) {
        this.setIndexRangeByDDL(indexList, schemaName, tableName);
        if (indexList.stream().anyMatch(idx -> Objects.isNull(idx.getGlobal()))) {
            this.setIndexRangeByQuery(indexList, schemaName, tableName);
        }
    }

    protected void setIndexRangeByQuery(List<DBTableIndex> indexList, String schemaName, String tableName) {
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("SELECT `table_id` from oceanbase.gv$table where database_name=");
            sb.value(schemaName);
            sb.append(" and");
            sb.append(" table_name=");
            sb.value(tableName);
            sb.append(" into @table_id");
            this.jdbcOperations.execute(sb.toString());
            sb = new MySQLSqlBuilder();
            sb.append("select database_name, table_type, index_type, replace(table_name, CONCAT('__idx_', @table_id, '_'),'') as ");
            sb.append(" index_name, case when index_type < 3 then true else false end as is_local_index from oceanbase.gv$table");
            sb.append(" where database_name=");
            sb.value(schemaName);
            sb.append(" and table_name like");
            sb.append(" CONCAT('__idx_', @table_id, '_%') and table_type=5");
            this.jdbcOperations.query(sb.toString(), (rs, num) -> {
                String indexName = rs.getString("index_name");
                Boolean isLocal = rs.getBoolean("is_local_index");
                indexList.forEach(dbTableIndex -> {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dbTableIndex.getWarning()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)dbTableIndex.getName(), (CharSequence)indexName)) {
                        dbTableIndex.setGlobal(isLocal == false);
                    }
                });
                return indexName;
            });
        }
        catch (Exception ex) {
            this.fillWarning(indexList, DBObjectType.INDEX, "query oceanbase.gv$table failed to get index ddl failed");
            log.warn("Failed to fetch indices of table {} by querying `oceanbase.gv$table`", (Object)tableName, (Object)ex);
        }
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        String sql = this.sqlMapper.getSql("get-partition");
        List result = this.jdbcOperations.query(sql, ps -> {
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
        }, (rs, rowNum) -> {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("partition_method", rs.getString("partition_method"));
            row.put("part_num", rs.getInt("part_num"));
            row.put("part_func_expr", rs.getString("part_func_expr"));
            row.put("is_sub_part_template", rs.getInt("is_sub_part_template"));
            row.put("part_name", rs.getString("part_name"));
            row.put("part_id", rs.getInt("part_id"));
            row.put("list_val", rs.getString("list_val"));
            row.put("high_bound_val", rs.getString("high_bound_val"));
            row.put("subpartition_method", rs.getString("subpartition_method"));
            row.put("sub_part_func_expr", rs.getString("sub_part_func_expr"));
            row.put("sub_part_num", rs.getInt("sub_part_num"));
            return row;
        });
        return this.getFromResultSet(result, schemaName, tableName);
    }

    @Override
    public Map<String, DBTablePartition> listTablePartitions(@NonNull String schemaName, List<String> tableNames) {
        List queryResult = DBSchemaAccessorUtil.partitionFind(tableNames, 2000, names -> {
            String sql = this.filterByValues(this.sqlMapper.getSql("list-partitions"), "table_name", (List<String>)names);
            return this.jdbcOperations.query(sql, new Object[]{schemaName}, (rs, rowNum) -> {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("table_name", rs.getString("table_name"));
                row.put("partition_method", rs.getString("partition_method"));
                row.put("part_num", rs.getInt("part_num"));
                row.put("part_func_expr", rs.getString("part_func_expr"));
                row.put("is_sub_part_template", rs.getInt("is_sub_part_template"));
                row.put("part_name", rs.getString("part_name"));
                row.put("part_id", rs.getInt("part_id"));
                row.put("list_val", rs.getString("list_val"));
                row.put("high_bound_val", rs.getString("high_bound_val"));
                row.put("subpartition_method", rs.getString("subpartition_method"));
                row.put("sub_part_func_expr", rs.getString("sub_part_func_expr"));
                row.put("sub_part_num", rs.getInt("sub_part_num"));
                return row;
            });
        });
        Map<String, List<Map>> tableName2Rows = queryResult.stream().collect(Collectors.groupingBy(m -> (String)m.get("table_name")));
        return tableName2Rows.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getFromResultSet((List)e.getValue(), schemaName, (String)e.getKey())));
    }

    private DBTablePartition getFromResultSet(List<Map<String, Object>> rows, String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        DBTablePartition subPartition = new DBTablePartition();
        partition.setSubpartition(subPartition);
        DBTablePartitionOption partitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        partition.setPartitionOption(partitionOption);
        partition.setSchemaName(schemaName);
        partition.setTableName(tableName);
        subPartition.setSchemaName(schemaName);
        DBTablePartitionOption subPartitionOption = new DBTablePartitionOption();
        subPartitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        subPartition.setPartitionOption(subPartitionOption);
        ArrayList<DBTablePartitionDefinition> partitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        partition.setPartitionDefinitions(partitionDefinitions);
        ArrayList<DBTablePartitionDefinition> subPartitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        subPartition.setPartitionDefinitions(subPartitionDefinitions);
        for (Map<String, Object> row : rows) {
            partitionOption.setType(DBTablePartitionType.fromValue((String)row.get("partition_method")));
            partitionOption.setPartitionsNum((Integer)row.get("part_num"));
            String expression = (String)row.get("part_func_expr");
            if (StringUtils.isNotEmpty((CharSequence)expression)) {
                if (partitionOption.getType().supportExpression()) {
                    partitionOption.setExpression(expression);
                } else {
                    partitionOption.setColumnNames(Arrays.asList(expression.split(",")));
                }
            }
            partition.setSubpartitionTemplated((Integer)row.get("is_sub_part_template") == 1);
            DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
            partitionDefinition.setName((String)row.get("part_name"));
            partitionDefinition.setOrdinalPosition((Integer)row.get("part_id"));
            partitionDefinition.setType(DBTablePartitionType.fromValue((String)row.get("partition_method")));
            String description = null;
            if (partitionDefinition.getType() == DBTablePartitionType.LIST || partitionDefinition.getType() == DBTablePartitionType.LIST_COLUMNS) {
                description = (String)row.get("list_val");
            } else if (partitionDefinition.getType() == DBTablePartitionType.RANGE || partitionDefinition.getType() == DBTablePartitionType.RANGE_COLUMNS) {
                description = (String)row.get("high_bound_val");
            }
            partitionDefinition.fillValues(description);
            partitionDefinitions.add(partitionDefinition);
            DBTablePartitionType subPartType = DBTablePartitionType.fromValue((String)row.get("subpartition_method"));
            String subPartExpression = (String)row.get("sub_part_func_expr");
            if ((subPartType == DBTablePartitionType.HASH || subPartType == DBTablePartitionType.KEY) && partition.getSubpartitionTemplated().booleanValue() && StringUtils.isNotBlank((CharSequence)subPartExpression)) {
                subPartitionOption.setType(subPartType);
                subPartitionOption.setPartitionsNum((Integer)row.get("sub_part_num"));
                if (subPartType.supportExpression()) {
                    subPartitionOption.setExpression(subPartExpression);
                    continue;
                }
                subPartitionOption.setColumnNames(Arrays.asList(subPartExpression.split(",")));
                continue;
            }
            partition.setWarning("Only support HASH/KEY subpartition currently");
        }
        return partition;
    }

    @Override
    public List<DBObjectIdentity> listSequences(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        if ("mysql".equals(schemaName) && this.VIEW_AS_BASE_TABLE.contains(tableName)) {
            DBView view = new DBView();
            view.setSchemaName("mysql");
            view.setViewName(tableName);
            return this.fillColumnInfoByDesc(view).getColumns();
        }
        return super.listTableColumns(schemaName, tableName);
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicTableColumns(String schemaName) {
        String sql = this.sqlMapper.getSql("list-basic-schema-table-columns");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName}, this.listBasicTableColumnRowMapper());
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicViewColumns(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select table_name from information_schema.views where table_schema=");
        sb.value(schemaName);
        List viewNames = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString("table_name"));
        ArrayList<DBTableColumn> columns = new ArrayList<DBTableColumn>();
        for (String viewName : viewNames) {
            columns.addAll(this.fillViewColumnInfoByDesc(schemaName, viewName));
        }
        return columns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public List<DBTableColumn> listBasicViewColumns(String schemaName, String viewName) {
        return this.fillViewColumnInfoByDesc(schemaName, viewName);
    }

    protected List<DBTableColumn> fillViewColumnInfoByDesc(String schemaName, String viewName) {
        List<DBTableColumn> columns = new ArrayList<DBTableColumn>();
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("desc ");
            if (StringUtils.isNotBlank((CharSequence)schemaName)) {
                sb.identifier(schemaName).append(".");
            }
            sb.identifier(viewName);
            columns = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> {
                DBTableColumn column = new DBTableColumn();
                column.setSchemaName(schemaName);
                column.setTableName(viewName);
                column.setName(rs.getString(1));
                column.setTypeName(rs.getString(2).split("\\(")[0]);
                return column;
            });
        }
        catch (Exception e) {
            log.warn("fail to get view column info, message={}", (Object)e.getMessage());
        }
        return columns;
    }
}

