/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBColumnTypeDisplay;
import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBPLObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBProcedure;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.mysql.BaseOBMySQLLessThan2277SchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

public class OBMySQLNoGreaterThan1479SchemaAccessor
extends BaseOBMySQLLessThan2277SchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLNoGreaterThan1479SchemaAccessor.class);
    private final String tenantName;
    protected JdbcOperations sysJdbcOperations;
    private static final Set<String> SPECIAL_TYPE_NAME = new HashSet<String>();

    public OBMySQLNoGreaterThan1479SchemaAccessor(JdbcOperations jdbcOperations, JdbcOperations sysJdbcOperations, String tenantName) {
        super(jdbcOperations, DBSchemaAccessorSqlMappers.get("schema/sql/obmysql/obmysql_1_4_79.yaml"));
        this.tenantName = tenantName;
        this.sysJdbcOperations = sysJdbcOperations;
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        try {
            return this.listBaseTables(schemaName, tableNameLike);
        }
        catch (Exception e) {
            log.warn("List tables failed, reason={}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        if (this.sysJdbcOperations == null) {
            throw new IllegalStateException("Query table partition info failed, please confirm that you have sys read permission");
        }
        String sql = this.sqlMapper.getSql("get-partition");
        List result = this.sysJdbcOperations.query(sql, ps -> {
            ps.setString(1, this.tenantName);
            ps.setString(2, schemaName);
            ps.setString(3, tableName);
        }, (rs, rowNum) -> {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("partition_method", rs.getString("partition_method"));
            row.put("part_num", rs.getInt("part_num"));
            row.put("part_func_expr", rs.getString("part_func_expr"));
            row.put("is_sub_part_template", rs.getInt("is_sub_part_template"));
            row.put("part_name", rs.getString("part_name"));
            row.put("part_id", rs.getInt("part_id"));
            row.put("high_bound_val", rs.getString("high_bound_val"));
            row.put("subpartition_method", rs.getString("subpartition_method"));
            row.put("sub_part_func_expr", rs.getString("sub_part_func_expr"));
            row.put("sub_part_num", rs.getInt("sub_part_num"));
            return row;
        });
        return this.getFromResultSet(result, schemaName, tableName);
    }

    @Override
    public Map<String, DBTablePartition> listTablePartitions(@NonNull String schemaName, List<String> tableNames) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        List queryResult = DBSchemaAccessorUtil.partitionFind(tableNames, 2000, names -> {
            String sql = this.filterByValues(this.sqlMapper.getSql("list-partitions"), "table_name", (List<String>)names);
            return this.jdbcOperations.query(sql, new Object[]{this.tenantName, schemaName}, (rs, rowNum) -> {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("table_name", rs.getString("table_name"));
                row.put("partition_method", rs.getString("partition_method"));
                row.put("part_num", rs.getInt("part_num"));
                row.put("part_func_expr", rs.getString("part_func_expr"));
                row.put("is_sub_part_template", rs.getInt("is_sub_part_template"));
                row.put("part_name", rs.getString("part_name"));
                row.put("part_id", rs.getInt("part_id"));
                row.put("high_bound_val", rs.getString("high_bound_val"));
                row.put("subpartition_method", rs.getString("subpartition_method"));
                row.put("sub_part_func_expr", rs.getString("sub_part_func_expr"));
                row.put("sub_part_num", rs.getInt("sub_part_num"));
                return row;
            });
        });
        Map<String, List<Map>> tableName2Rows = queryResult.stream().collect(Collectors.groupingBy(m -> (String)m.get("table_name")));
        return tableName2Rows.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getFromResultSet((List)e.getValue(), schemaName, (String)e.getKey())));
    }

    private DBTablePartition getFromResultSet(List<Map<String, Object>> rows, String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        DBTablePartition subPartition = new DBTablePartition();
        partition.setSubpartition(subPartition);
        partition.setSchemaName(schemaName);
        partition.setTableName(tableName);
        subPartition.setSchemaName(schemaName);
        DBTablePartitionOption partitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        partition.setPartitionOption(partitionOption);
        DBTablePartitionOption subPartitionOption = new DBTablePartitionOption();
        partitionOption.setType(DBTablePartitionType.NOT_PARTITIONED);
        subPartition.setPartitionOption(subPartitionOption);
        ArrayList<DBTablePartitionDefinition> partitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        partition.setPartitionDefinitions(partitionDefinitions);
        ArrayList<DBTablePartitionDefinition> subPartitionDefinitions = new ArrayList<DBTablePartitionDefinition>();
        subPartition.setPartitionDefinitions(subPartitionDefinitions);
        for (Map<String, Object> row : rows) {
            partitionOption.setType(DBTablePartitionType.fromValue((String)row.get("partition_method")));
            partitionOption.setPartitionsNum((Integer)row.get("part_num"));
            String expression = (String)row.get("part_func_expr");
            if (StringUtils.isNotEmpty((CharSequence)expression)) {
                if (partitionOption.getType().supportExpression()) {
                    partitionOption.setExpression(expression);
                } else {
                    partitionOption.setColumnNames(Arrays.asList(expression.split(",")));
                }
            }
            partition.setSubpartitionTemplated((Integer)row.get("is_sub_part_template") == 1);
            DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
            partitionDefinition.setName((String)row.get("part_name"));
            partitionDefinition.setOrdinalPosition((Integer)row.get("part_id"));
            partitionDefinition.setType(DBTablePartitionType.fromValue((String)row.get("partition_method")));
            String description = null;
            if (partitionDefinition.getType() == DBTablePartitionType.RANGE || partitionDefinition.getType() == DBTablePartitionType.RANGE_COLUMNS) {
                description = (String)row.get("high_bound_val");
            }
            partitionDefinition.fillValues(description);
            partitionDefinitions.add(partitionDefinition);
            DBTablePartitionType subPartType = DBTablePartitionType.fromValue((String)row.get("subpartition_method"));
            String subPartExpression = (String)row.get("sub_part_func_expr");
            if ((subPartType == DBTablePartitionType.HASH || subPartType == DBTablePartitionType.KEY) && partition.getSubpartitionTemplated().booleanValue() && StringUtils.isNotBlank((CharSequence)subPartExpression)) {
                subPartitionOption.setType(subPartType);
                subPartitionOption.setPartitionsNum((Integer)row.get("sub_part_num"));
                if (subPartType.supportExpression()) {
                    subPartitionOption.setExpression(subPartExpression);
                    continue;
                }
                subPartitionOption.setColumnNames(Arrays.asList(subPartExpression.split(",")));
                continue;
            }
            partition.setWarning("Only support HASH/KEY subpartition currently, please check comparing ddl");
        }
        return partition;
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        List<DBTableColumn> columns = super.listTableColumns(schemaName, tableName);
        if (CollectionUtils.isNotEmpty(columns)) {
            columns.forEach(this::fillPrecisionAndScale);
        }
        return columns;
    }

    @Override
    public Map<String, List<DBTableColumn>> listTableColumns(String schemaName, List<String> tableNames) {
        Map<String, List<DBTableColumn>> tableName2Columns = super.listTableColumns(schemaName, tableNames);
        for (List<DBTableColumn> columnList : tableName2Columns.values()) {
            if (!CollectionUtils.isNotEmpty(columnList)) continue;
            columnList.forEach(this::fillPrecisionAndScale);
        }
        return tableName2Columns;
    }

    @Override
    protected void fillIndexRange(List<DBTableIndex> indexList, String schemaName, String tableName) {
        indexList.forEach(index -> index.setGlobal(false));
    }

    private void fillPrecisionAndScale(DBTableColumn column) {
        if (SPECIAL_TYPE_NAME.contains(column.getTypeName())) {
            String precisionAndScale = DBSchemaAccessorUtil.parsePrecisionAndScale(column.getFullTypeName());
            if (StringUtils.isBlank((CharSequence)precisionAndScale)) {
                return;
            }
            DBColumnTypeDisplay display = DBColumnTypeDisplay.fromName(column.getTypeName());
            if (precisionAndScale.contains(",")) {
                String[] seg = precisionAndScale.split(",");
                if (seg.length == 2) {
                    if (display.displayPrecision()) {
                        column.setPrecision(Long.parseLong(seg[0]));
                    }
                    if (display.displayScale()) {
                        column.setScale(Integer.parseInt(seg[1]));
                    }
                }
            } else if (display.displayPrecision()) {
                column.setPrecision(Long.parseLong(precisionAndScale));
            }
        }
    }

    @Override
    public List<DBPLObjectIdentity> listFunctions(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public List<DBPLObjectIdentity> listProcedures(String schemaName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBFunction getFunction(String schemaName, String functionName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public DBProcedure getProcedure(String schemaName, String procedureName) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    static {
        SPECIAL_TYPE_NAME.add("bit");
        SPECIAL_TYPE_NAME.add("int");
        SPECIAL_TYPE_NAME.add("tinyint");
        SPECIAL_TYPE_NAME.add("smallint");
        SPECIAL_TYPE_NAME.add("mediumint");
        SPECIAL_TYPE_NAME.add("bigint");
        SPECIAL_TYPE_NAME.add("float");
        SPECIAL_TYPE_NAME.add("double");
    }
}

