/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.oracle;

import com.oceanbase.tools.dbbrowser.model.DBSynonymType;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.oracle.OBOracleSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.OracleDataDictTableNames;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

public class OBOracleLessThan400SchemaAccessor
extends OBOracleSchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBOracleLessThan400SchemaAccessor.class);

    public OBOracleLessThan400SchemaAccessor(JdbcOperations jdbcOperations, OracleDataDictTableNames dataDictTableNames) {
        super(jdbcOperations, dataDictTableNames);
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/oboracle/oboracle_3_x.yaml");
    }

    @Override
    public DBTable.DBTableOptions getTableOptions(String schemaName, String tableName) {
        DBTable.DBTableOptions tableOptions = new DBTable.DBTableOptions();
        this.obtainTableCharset(Collections.singletonList(tableOptions));
        this.obtainTableCollation(Collections.singletonList(tableOptions));
        String sql = this.sqlMapper.getSql("get-table-option");
        try {
            this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, rs -> {
                tableOptions.setCreateTime(rs.getTimestamp("GMT_CREATE"));
                tableOptions.setUpdateTime(rs.getTimestamp("GMT_MODIFIED"));
                tableOptions.setComment(rs.getString("COMMENT"));
                tableOptions.setTabletSize(rs.getLong("TABLET_SIZE"));
            });
        }
        catch (Exception ex) {
            log.warn("get table options failed, schema={}, table={}, reason:", new Object[]{schemaName, tableName, ex});
        }
        return tableOptions;
    }

    @Override
    public DBTablePartition getPartition(String schemaName, String tableName) {
        String sql = this.sqlMapper.getSql("get-partition");
        List queryResult = this.jdbcOperations.query(sql, new Object[]{schemaName, tableName}, (rs, num) -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("PARTITION_METHOD", rs.getString("PARTITION_METHOD"));
            result.put("PART_NUM", rs.getInt("PART_NUM"));
            result.put("EXPRESSION", rs.getString("EXPRESSION"));
            result.put("PART_NAME", rs.getString("PART_NAME"));
            result.put("PART_ID", rs.getInt("PART_ID"));
            result.put("MAX_VALUE", rs.getString("MAX_VALUE"));
            result.put("LIST_VALUE", rs.getString("LIST_VALUE"));
            return result;
        });
        return this.getFromResultSet(queryResult, schemaName, tableName);
    }

    @Override
    public Map<String, DBTablePartition> listTablePartitions(@NonNull String schemaName, List<String> tableNames) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        List queryResult = DBSchemaAccessorUtil.partitionFind(tableNames, 2000, names -> {
            String sql = this.filterByValues(this.sqlMapper.getSql("list-partitions"), "TABLE_NAME", (List<String>)names);
            return this.jdbcOperations.query(sql, new Object[]{schemaName}, (rs, rowNum) -> {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("TABLE_NAME", rs.getString("TABLE_NAME"));
                row.put("PARTITION_METHOD", rs.getString("PARTITION_METHOD"));
                row.put("PART_NUM", rs.getInt("PART_NUM"));
                row.put("EXPRESSION", rs.getString("EXPRESSION"));
                row.put("PART_NAME", rs.getString("PART_NAME"));
                row.put("PART_ID", rs.getInt("PART_ID"));
                row.put("MAX_VALUE", rs.getString("MAX_VALUE"));
                row.put("LIST_VALUE", rs.getString("LIST_VALUE"));
                return row;
            });
        });
        Map<String, List<Map>> tableName2Rows = queryResult.stream().collect(Collectors.groupingBy(m -> (String)m.get("TABLE_NAME")));
        return tableName2Rows.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getFromResultSet((List)e.getValue(), schemaName, (String)e.getKey())));
    }

    private DBTablePartition getFromResultSet(List<Map<String, Object>> rows, String schemaName, String tableName) {
        DBTablePartition partition = new DBTablePartition();
        partition.setPartitionOption(new DBTablePartitionOption());
        partition.setPartitionDefinitions(new ArrayList<DBTablePartitionDefinition>());
        partition.setSchemaName(schemaName);
        partition.setTableName(tableName);
        for (Map<String, Object> row : rows) {
            DBTablePartitionOption option = partition.getPartitionOption();
            option.setType(DBTablePartitionType.fromValue((String)row.get("PARTITION_METHOD")));
            option.setPartitionsNum((Integer)row.get("PART_NUM"));
            String expression = (String)row.get("EXPRESSION");
            if (option.getType().supportExpression()) {
                option.setExpression(expression);
            } else {
                option.setColumnNames(Arrays.asList(expression.split(",")));
            }
            DBTablePartitionDefinition partitionDefinition = new DBTablePartitionDefinition();
            partitionDefinition.setName((String)row.get("PART_NAME"));
            partitionDefinition.setOrdinalPosition((Integer)row.get("PART_ID"));
            partitionDefinition.setType(option.getType());
            String maxValue = (String)row.get("MAX_VALUE");
            String listValue = (String)row.get("LIST_VALUE");
            partitionDefinition.fillValues(StringUtils.isNotEmpty((CharSequence)maxValue) ? maxValue : listValue);
            partition.getPartitionDefinitions().add(partitionDefinition);
        }
        return partition;
    }

    @Override
    protected String getSynonymOwnerSymbol(DBSynonymType synonymType, String schemaName) {
        if (synonymType.equals((Object)DBSynonymType.PUBLIC)) {
            return "PUBLIC";
        }
        if (synonymType.equals((Object)DBSynonymType.COMMON)) {
            return schemaName;
        }
        throw new UnsupportedOperationException("Not supported Synonym type");
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicTableColumns(String schemaName) {
        String sql = this.sqlMapper.getSql("list-basic-schema-table-columns");
        List tableColumns = this.jdbcOperations.query(sql, new Object[]{schemaName}, this.listBasicColumnsRowMapper());
        return tableColumns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public Map<String, List<DBTableColumn>> listBasicViewColumns(String schemaName) {
        OracleSqlBuilder sb = new OracleSqlBuilder();
        sb.append("select view_name from all_views where owner = ").value(schemaName);
        List viewNames = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> rs.getString("view_name"));
        ArrayList<DBTableColumn> columns = new ArrayList<DBTableColumn>();
        for (String viewName : viewNames) {
            columns.addAll(this.fillViewColumnInfoByDesc(schemaName, viewName));
        }
        return columns.stream().collect(Collectors.groupingBy(DBTableColumn::getTableName));
    }

    @Override
    public List<DBTableColumn> listBasicViewColumns(String schemaName, String viewName) {
        return this.fillViewColumnInfoByDesc(schemaName, viewName);
    }

    protected List<DBTableColumn> fillViewColumnInfoByDesc(String schemaName, String viewName) {
        List<DBTableColumn> columns = new ArrayList<DBTableColumn>();
        try {
            OracleSqlBuilder sb = new OracleSqlBuilder();
            sb.append("desc ");
            if (StringUtils.isNotBlank((CharSequence)schemaName)) {
                sb.identifier(schemaName).append(".");
            }
            sb.identifier(viewName);
            columns = this.jdbcOperations.query(sb.toString(), (rs, rowNum) -> {
                DBTableColumn column = new DBTableColumn();
                column.setSchemaName(schemaName);
                column.setTableName(viewName);
                column.setName(rs.getString(1));
                column.setTypeName(rs.getString(2).split("\\(")[0]);
                return column;
            });
        }
        catch (Exception e) {
            log.warn("fail to get view column info, message={}", (Object)e.getMessage());
        }
        return columns;
    }
}

