/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.stats.mysql;

import com.oceanbase.tools.dbbrowser.model.DBSession;
import com.oceanbase.tools.dbbrowser.stats.mysql.OBMySQLStatsAccessor;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class OBMySQLNoLessThan400StatsAccessor
extends OBMySQLStatsAccessor {
    private static final String OB40_SESSION_COLUMNS = " `ID`,   `USER` as USERNAME,   `DB` as DATABASE_NAME,   COMMAND,   STATE,   `USER_CLIENT_IP` as HOST,   HOST as PROXY_HOST,   TIME as EXECUTE_TIME,   CASE     WHEN `TRANS_STATE` IS NULL OR `TRANS_STATE` IN ('', 'IDLE', 'IN_TERMINATE', 'ABORTED',      'ROLLED_BACK', 'COMMITED') THEN 'IDLE'     WHEN `TRANS_STATE` IN ('ACTIVE', 'IMPLICIT_ACTIVE', 'ROLLBACK_SAVEPOINT') THEN 'ACTIVE'     WHEN `TRANS_STATE` IN ('COMMIT_TIMEOUT', 'COMMIT_UNKNOWN') THEN 'TIMEOUT'     ELSE 'UNKNOWN'   END AS TRANS_STATE,   TRANS_ID,   `SQL_ID`,   `TRACE_ID`,   LEFT(`INFO`, 200) AS LATEST_QUERIES ";
    private static final String OB40_QUERY_ALL_SESSIONS = "SELECT  `ID`,   `USER` as USERNAME,   `DB` as DATABASE_NAME,   COMMAND,   STATE,   `USER_CLIENT_IP` as HOST,   HOST as PROXY_HOST,   TIME as EXECUTE_TIME,   CASE     WHEN `TRANS_STATE` IS NULL OR `TRANS_STATE` IN ('', 'IDLE', 'IN_TERMINATE', 'ABORTED',      'ROLLED_BACK', 'COMMITED') THEN 'IDLE'     WHEN `TRANS_STATE` IN ('ACTIVE', 'IMPLICIT_ACTIVE', 'ROLLBACK_SAVEPOINT') THEN 'ACTIVE'     WHEN `TRANS_STATE` IN ('COMMIT_TIMEOUT', 'COMMIT_UNKNOWN') THEN 'TIMEOUT'     ELSE 'UNKNOWN'   END AS TRANS_STATE,   TRANS_ID,   `SQL_ID`,   `TRACE_ID`,   LEFT(`INFO`, 200) AS LATEST_QUERIES  FROM oceanbase.GV$OB_PROCESSLIST";
    private static final String OB40_QUERY_CURRENT_SESSION = "SELECT  `ID`,   `USER` as USERNAME,   `DB` as DATABASE_NAME,   COMMAND,   STATE,   `USER_CLIENT_IP` as HOST,   HOST as PROXY_HOST,   TIME as EXECUTE_TIME,   CASE     WHEN `TRANS_STATE` IS NULL OR `TRANS_STATE` IN ('', 'IDLE', 'IN_TERMINATE', 'ABORTED',      'ROLLED_BACK', 'COMMITED') THEN 'IDLE'     WHEN `TRANS_STATE` IN ('ACTIVE', 'IMPLICIT_ACTIVE', 'ROLLBACK_SAVEPOINT') THEN 'ACTIVE'     WHEN `TRANS_STATE` IN ('COMMIT_TIMEOUT', 'COMMIT_UNKNOWN') THEN 'TIMEOUT'     ELSE 'UNKNOWN'   END AS TRANS_STATE,   TRANS_ID,   `SQL_ID`,   `TRACE_ID`,   LEFT(`INFO`, 200) AS LATEST_QUERIES  FROM oceanbase.V$OB_PROCESSLIST WHERE `ID`=connection_id()";

    public OBMySQLNoLessThan400StatsAccessor(@NonNull JdbcOperations jdbcOperations) {
        super(jdbcOperations);
        if (jdbcOperations == null) {
            throw new NullPointerException("jdbcOperations is marked non-null but is null");
        }
    }

    @Override
    public List<DBSession> listAllSessions() {
        return this.jdbcOperations.query(OB40_QUERY_ALL_SESSIONS, (RowMapper)new BeanPropertyRowMapper(DBSession.class));
    }

    @Override
    public DBSession currentSession() {
        List sessions = this.jdbcOperations.query(OB40_QUERY_CURRENT_SESSION, (RowMapper)new BeanPropertyRowMapper(DBSession.class));
        return CollectionUtils.isEmpty((Collection)sessions) ? DBSession.unknown() : (DBSession)sessions.get(0);
    }
}

