/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.stats.oracle;

import com.oceanbase.tools.dbbrowser.model.DBSession;
import com.oceanbase.tools.dbbrowser.stats.oracle.BaseOBOracleStatsAccessor;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class OracleStatsAccessor
extends BaseOBOracleStatsAccessor {
    private static final String LIST_ALL_SESSIONS = "SELECT \na.SID || ', ' || a.SERIAL# AS ID,\na.USERNAME, \na.SCHEMANAME as DATABASE_NAME, \na.COMMAND, \na.STATUS as STATE, \na.MACHINE as HOST, \na.PORT, \na.SQL_ID, \nb.SQL_TEXT as LATEST_QUERIES,\nb.ELAPSED_TIME as EXECUTE_TIME\nFROM V$SESSION a left join V$SQL b on a.SQL_ID = b.SQL_ID";
    private static final String GET_CURRENT_SESSION = "SELECT \na.SID || ', ' || a.SERIAL# AS ID,\na.USERNAME, \na.SCHEMANAME as DATABASE_NAME, \na.COMMAND, \na.STATUS as STATE, \na.MACHINE as HOST, \na.PORT, \na.SQL_ID, \nb.SQL_TEXT as LATEST_QUERIES,\nb.ELAPSED_TIME as EXECUTE_TIME\nFROM V$SESSION a left join V$SQL b on a.SQL_ID = b.SQL_ID  WHERE a.SID = SYS_CONTEXT('USERENV', 'SID') and a.AUDSID=SYS_CONTEXT('USERENV', 'SESSIONID') and a.status = 'ACTIVE'";

    public OracleStatsAccessor(JdbcOperations jdbcOperations) {
        super(jdbcOperations);
    }

    @Override
    public DBSession currentSession() {
        return (DBSession)this.jdbcOperations.queryForObject(GET_CURRENT_SESSION, (RowMapper)new BeanPropertyRowMapper(DBSession.class));
    }

    @Override
    public List<DBSession> listAllSessions() {
        return this.jdbcOperations.query(LIST_ALL_SESSIONS, (RowMapper)new BeanPropertyRowMapper(DBSession.class));
    }
}

