/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser;

import com.oceanbase.tools.dbbrowser.DBBrowserFactory;
import org.apache.commons.lang3.Validate;

public abstract class AbstractDBBrowserFactory<T>
implements DBBrowserFactory<T> {
    protected String type;

    @Override
    public T create() {
        Validate.notNull((Object)this.type, (String)"Type can not be null", (Object[])new Object[0]);
        switch (this.type) {
            case "ORACLE": {
                return this.buildForOracle();
            }
            case "MYSQL": {
                return this.buildForMySQL();
            }
            case "DORIS": {
                return this.buildForDoris();
            }
            case "OB_ORACLE": {
                return this.buildForOBOracle();
            }
            case "OB_MYSQL": {
                return this.buildForOBMySQL();
            }
            case "ODP_SHARDING_OB_MYSQL": {
                return this.buildForOdpSharding();
            }
        }
        throw new IllegalStateException("Not supported for the type, " + this.type);
    }

    public abstract T buildForDoris();

    public abstract T buildForMySQL();

    public abstract T buildForOBMySQL();

    public abstract T buildForOBOracle();

    public abstract T buildForOracle();

    public abstract T buildForOdpSharding();

    public AbstractDBBrowserFactory<T> setType(String type) {
        this.type = type;
        return this;
    }
}

