/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBColumnGroupElement;
import com.oceanbase.tools.dbbrowser.model.DBIndexType;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;

public abstract class DBTableIndexEditor
implements DBObjectEditor<DBTableIndex> {
    @Override
    public String generateCreateObjectDDL(@NotNull DBTableIndex index) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("CREATE ");
        this.appendIndexModifiers(index, sqlBuilder);
        sqlBuilder.append(" INDEX ").identifier(index.getName());
        this.appendIndexType(index, sqlBuilder);
        sqlBuilder.append(" ON ").append(this.getFullyQualifiedTableName(index)).append(" (");
        this.appendIndexColumns(index, sqlBuilder);
        sqlBuilder.append(")");
        this.appendIndexOptions(index, sqlBuilder);
        if (CollectionUtils.isNotEmpty(index.getColumnGroups())) {
            sqlBuilder.append(" WITH COLUMN GROUP(").append(index.getColumnGroups().stream().map(DBColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        return sqlBuilder.toString().trim() + ";\n";
    }

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBTableIndex index) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        this.appendIndexModifiers(index, sqlBuilder);
        sqlBuilder.append(" INDEX ").identifier(index.name());
        this.appendIndexType(index, sqlBuilder);
        sqlBuilder.append(" (");
        this.appendIndexColumns(index, sqlBuilder);
        sqlBuilder.append(")");
        this.appendIndexOptions(index, sqlBuilder);
        if (CollectionUtils.isNotEmpty(index.getColumnGroups())) {
            sqlBuilder.append(" WITH COLUMN GROUP(").append(index.getColumnGroups().stream().map(DBColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        return sqlBuilder.toString().trim();
    }

    protected void appendIndexColumns(DBTableIndex index, SqlBuilder sqlBuilder) {
        List<String> columnNames = index.getColumnNames();
        if (Objects.isNull(columnNames)) {
            return;
        }
        boolean isFirstColumn = true;
        for (String columnName : columnNames) {
            if (!isFirstColumn) {
                sqlBuilder.append(", ");
            }
            isFirstColumn = false;
            sqlBuilder.identifier(columnName);
            this.appendIndexColumnModifiers(index, sqlBuilder);
        }
    }

    protected abstract void appendIndexColumnModifiers(DBTableIndex var1, SqlBuilder var2);

    protected void appendIndexType(DBTableIndex index, SqlBuilder sqlBuilder) {
    }

    protected void appendIndexModifiers(DBTableIndex index, SqlBuilder sqlBuilder) {
        if (index.getType() == DBIndexType.UNIQUE) {
            sqlBuilder.append("UNIQUE");
        }
    }

    protected abstract void appendIndexOptions(DBTableIndex var1, SqlBuilder var2);

    @Override
    public String generateUpdateObjectDDL(@NotNull DBTableIndex oldIndex, @NotNull DBTableIndex newIndex) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (!Objects.equals(oldIndex, newIndex)) {
            String drop = this.generateDropObjectDDL(oldIndex);
            sqlBuilder.append(drop).append(this.generateCreateObjectDDL(newIndex));
            return sqlBuilder.toString();
        }
        if (!StringUtils.equals((CharSequence)oldIndex.getName(), (CharSequence)newIndex.getName())) {
            sqlBuilder.append(this.generateRenameObjectDDL(oldIndex, newIndex)).append(";").line();
        }
        sqlBuilder.append(this.generateUpdateVisibility(oldIndex, newIndex));
        return sqlBuilder.toString();
    }

    private String generateUpdateVisibility(@NotNull DBTableIndex oldIndex, @NotNull DBTableIndex newIndex) {
        if (Objects.equals(oldIndex.getVisible(), newIndex.getVisible())) {
            return "";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        String visibility = Boolean.FALSE.equals(newIndex.getVisible()) ? "INVISIBLE" : "VISIBLE";
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(newIndex)).append(" ALTER INDEX ").identifier(newIndex.getName()).space().append(visibility).append(";").line();
        return sqlBuilder.toString();
    }

    @Override
    public String generateUpdateObjectListDDL(Collection<DBTableIndex> oldIndexes, Collection<DBTableIndex> newIndexes) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (CollectionUtils.isEmpty(oldIndexes)) {
            if (CollectionUtils.isNotEmpty(newIndexes)) {
                newIndexes.forEach(column -> sqlBuilder.append(this.generateCreateObjectDDL((DBTableIndex)column)));
            }
            return sqlBuilder.toString();
        }
        if (CollectionUtils.isEmpty(newIndexes)) {
            if (CollectionUtils.isNotEmpty(oldIndexes)) {
                oldIndexes.forEach(column -> sqlBuilder.append(this.generateDropObjectDDL((DBTableIndex)column)));
            }
            return sqlBuilder.toString();
        }
        HashMap position2OldIndex = new HashMap();
        HashMap position2NewIndex = new HashMap();
        oldIndexes.forEach(oldIndex -> position2OldIndex.put(oldIndex.getOrdinalPosition(), oldIndex));
        newIndexes.forEach(newIndex -> {
            if (Objects.nonNull(newIndex.getOrdinalPosition())) {
                position2NewIndex.put(newIndex.getOrdinalPosition(), newIndex);
            }
        });
        for (DBTableIndex newIndex2 : newIndexes) {
            if (Objects.isNull(newIndex2.getOrdinalPosition())) {
                sqlBuilder.append(this.generateCreateObjectDDL(newIndex2));
                continue;
            }
            if (!position2OldIndex.containsKey(newIndex2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateUpdateObjectDDL((DBTableIndex)position2OldIndex.get(newIndex2.getOrdinalPosition()), newIndex2));
        }
        for (DBTableIndex oldIndex2 : oldIndexes) {
            if (position2NewIndex.containsKey(oldIndex2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateDropObjectDDL(oldIndex2));
        }
        return sqlBuilder.toString();
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBTableIndex dbObject) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(dbObject)).append(" DROP INDEX ").identifier(dbObject.getName());
        return sqlBuilder.toString().trim() + ";\n";
    }

    protected abstract SqlBuilder sqlBuilder();

    protected String getFullyQualifiedTableName(@NotNull DBTableIndex index) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (StringUtils.isNotEmpty((CharSequence)index.getSchemaName())) {
            sqlBuilder.identifier(index.getSchemaName()).append(".");
        }
        if (StringUtils.isNotEmpty((CharSequence)index.getTableName())) {
            sqlBuilder.identifier(index.getTableName());
        }
        return sqlBuilder.toString();
    }
}

