/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.AbstractDBBrowserFactory;
import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.MySQLDBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.OBMySQLDBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.OBMySQLLessThan2277PartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.OBMySQLLessThan400DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.oracle.OBOracleLessThan400DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.oracle.OracleDBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.util.VersionUtils;
import org.apache.commons.lang3.Validate;

public class DBTablePartitionEditorFactory
extends AbstractDBBrowserFactory<DBTablePartitionEditor> {
    private String dbVersion;

    @Override
    public DBTablePartitionEditor buildForDoris() {
        return this.buildForMySQL();
    }

    @Override
    public DBTablePartitionEditor buildForMySQL() {
        return new MySQLDBTablePartitionEditor();
    }

    @Override
    public DBTablePartitionEditor buildForOBMySQL() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isLessThan(this.dbVersion, "2.2.77")) {
            return new OBMySQLLessThan2277PartitionEditor();
        }
        if (VersionUtils.isLessThan(this.dbVersion, "4.0.0")) {
            return new OBMySQLLessThan400DBTablePartitionEditor();
        }
        return new OBMySQLDBTablePartitionEditor();
    }

    @Override
    public DBTablePartitionEditor buildForOBOracle() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isLessThan(this.dbVersion, "4.0.0")) {
            return new OBOracleLessThan400DBTablePartitionEditor();
        }
        return new OracleDBTablePartitionEditor();
    }

    @Override
    public DBTablePartitionEditor buildForOracle() {
        return new OracleDBTablePartitionEditor();
    }

    @Override
    public DBTablePartitionEditor buildForOdpSharding() {
        return new MySQLDBTablePartitionEditor();
    }

    public DBTablePartitionEditorFactory setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
        return this;
    }
}

