/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MySQLDBTablePartitionEditor
extends DBTablePartitionEditor {
    @Override
    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBTablePartition partition) {
        if (partition.getPartitionOption().getType() == DBTablePartitionType.NOT_PARTITIONED) {
            return "";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(partition)).space().append(this.generateCreateDefinitionDDL(partition));
        return sqlBuilder.toString().trim() + ";\n";
    }

    @Override
    public String generateDropObjectDDL(DBTablePartition dbObject) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        String fullyQualifiedTableName = this.getFullyQualifiedTableName(dbObject);
        sqlBuilder.append("ALTER TABLE ").append(fullyQualifiedTableName).append(" REMOVE PARTITIONING").append(";").line();
        return sqlBuilder.toString();
    }

    @Override
    protected void appendDefinitions(DBTablePartition partition, SqlBuilder sqlBuilder) {
        DBTablePartitionType type = partition.getPartitionOption().getType();
        if ((type == DBTablePartitionType.HASH || type == DBTablePartitionType.KEY) && CollectionUtils.isEmpty(partition.getPartitionDefinitions())) {
            return;
        }
        sqlBuilder.append("(\n");
        boolean isFirstColumn = true;
        for (DBTablePartitionDefinition definition : partition.getPartitionDefinitions()) {
            if (!isFirstColumn) {
                sqlBuilder.append(",").line();
            }
            isFirstColumn = false;
            this.appendDefinition(partition.getPartitionOption(), definition, sqlBuilder);
        }
        sqlBuilder.append("\n)");
    }

    @Override
    protected void appendDefinition(DBTablePartitionOption option, DBTablePartitionDefinition definition, SqlBuilder sqlBuilder) {
        sqlBuilder.append("PARTITION ").identifier(definition.getName());
        if (option.getType() == DBTablePartitionType.RANGE || option.getType() == DBTablePartitionType.RANGE_COLUMNS) {
            if (Objects.nonNull(definition.getMaxValues())) {
                sqlBuilder.append(" VALUES LESS THAN (").append(String.join((CharSequence)",", definition.getMaxValues())).append(")");
            }
        } else if ((option.getType() == DBTablePartitionType.LIST || option.getType() == DBTablePartitionType.LIST_COLUMNS) && Objects.nonNull(definition.getValuesList())) {
            sqlBuilder.append(" VALUES IN (").append(DBSchemaAccessorUtil.parseListRangeValuesList(definition.getValuesList())).append(")");
        }
    }

    @Override
    protected String modifyPartitionType(@NotNull DBTablePartition oldPartition, @NotNull DBTablePartition newPartition) {
        return this.generateCreateObjectDDL(newPartition);
    }

    @Override
    public String generateAddPartitionDefinitionDDL(@NotNull DBTablePartitionDefinition definition, @NotNull DBTablePartitionOption option, String fullyQualifiedTableName) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(fullyQualifiedTableName).append(" ADD PARTITION(");
        this.appendDefinition(option, definition, sqlBuilder);
        sqlBuilder.append(");").line();
        return sqlBuilder.toString();
    }

    @Override
    public String generateAddPartitionDefinitionDDL(String schemaName, @NonNull String tableName, @NonNull DBTablePartitionOption option, List<DBTablePartitionDefinition> definitions) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        DBTablePartitionType partitionType = option.getType();
        if (partitionType != DBTablePartitionType.RANGE && partitionType != DBTablePartitionType.RANGE_COLUMNS && partitionType != DBTablePartitionType.LIST && partitionType != DBTablePartitionType.LIST_COLUMNS) {
            return "";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ");
        if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
            sqlBuilder.identifier(schemaName).append(".");
        }
        sqlBuilder.identifier(tableName).append(" ADD PARTITION (").append("\n\t");
        Validate.isTrue((!CollectionUtils.isEmpty(definitions) ? 1 : 0) != 0, (String)"Partition elements can not be empty", (Object[])new Object[0]);
        for (int i = 0; i < definitions.size(); ++i) {
            this.appendDefinition(option, definitions.get(i), sqlBuilder);
            if (i >= definitions.size() - 1) continue;
            sqlBuilder.append(",\n\t");
        }
        return sqlBuilder.append(");").line().toString();
    }

    @Override
    protected void generateCreateTemplateSubPartition(DBTablePartition partition, SqlBuilder sqlBuilder) {
        if (Objects.isNull(partition.getSubpartition())) {
            return;
        }
        DBTablePartitionOption subPartOption = partition.getSubpartition().getPartitionOption();
        if (Objects.isNull(subPartOption)) {
            return;
        }
        if (partition.getSubpartitionTemplated().booleanValue() && (subPartOption.getType() == DBTablePartitionType.HASH || subPartOption.getType() == DBTablePartitionType.KEY)) {
            sqlBuilder.append("SUBPARTITION BY ").append(subPartOption.getType().getValue()).append("(");
            this.appendExpression(partition.getSubpartition(), sqlBuilder);
            sqlBuilder.append(") subpartitions ").append(String.valueOf(subPartOption.getPartitionsNum()));
        }
    }
}

