/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.DBTableIndexEditor;
import com.oceanbase.tools.dbbrowser.model.DBIndexAlgorithm;
import com.oceanbase.tools.dbbrowser.model.DBIndexType;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class MySQLNoLessThan5700IndexEditor
extends DBTableIndexEditor {
    @Override
    protected void appendIndexColumnModifiers(DBTableIndex index, SqlBuilder sqlBuilder) {
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTableIndex oldIndex, @NotNull DBTableIndex newIndex) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(oldIndex)).append(" RENAME INDEX ").identifier(oldIndex.getName()).append(" TO ").identifier(newIndex.getName());
        return sqlBuilder.toString();
    }

    @Override
    protected void appendIndexModifiers(DBTableIndex index, SqlBuilder sqlBuilder) {
        if (DBIndexType.FULLTEXT == index.getType()) {
            sqlBuilder.append(" FULLTEXT");
        } else if (DBIndexType.SPATIAL == index.getType()) {
            sqlBuilder.append(" SPATIAL");
        } else {
            super.appendIndexModifiers(index, sqlBuilder);
        }
    }

    @Override
    protected void appendIndexType(DBTableIndex index, SqlBuilder sqlBuilder) {
        DBIndexAlgorithm algorithm = index.getAlgorithm();
        if (DBIndexType.FULLTEXT != index.getType() && Objects.nonNull((Object)algorithm) && algorithm != DBIndexAlgorithm.UNKNOWN) {
            sqlBuilder.append(" USING ").append(index.getAlgorithm().getValue());
        }
    }

    @Override
    protected void appendIndexOptions(DBTableIndex index, SqlBuilder sqlBuilder) {
        if (Objects.nonNull(index.getKeyBlockSize())) {
            sqlBuilder.append(" KEY_BLOCK_SIZE ").append(String.valueOf(index.getKeyBlockSize()));
        }
        if (index.getType() == DBIndexType.FULLTEXT && StringUtils.isNotBlank((CharSequence)index.getParserName())) {
            sqlBuilder.append(" WITH PARSER ").append(index.getParserName());
        }
        if (StringUtils.isNotBlank((CharSequence)index.getComment())) {
            sqlBuilder.append(" COMMENT ").value(index.getComment());
        }
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new MySQLSqlBuilder();
    }

    @Override
    public boolean editable() {
        return true;
    }
}

