/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.mysql;

import com.oceanbase.tools.dbbrowser.editor.mysql.MySQLNoLessThan5700IndexEditor;
import com.oceanbase.tools.dbbrowser.model.DBIndexType;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Objects;

public class OBMySQLIndexEditor
extends MySQLNoLessThan5700IndexEditor {
    @Override
    protected void appendIndexModifiers(DBTableIndex index, SqlBuilder sqlBuilder) {
        if (DBIndexType.FULLTEXT == index.getType()) {
            sqlBuilder.append(" FULLTEXT");
        } else {
            super.appendIndexModifiers(index, sqlBuilder);
        }
    }

    @Override
    protected void appendIndexOptions(DBTableIndex index, SqlBuilder sqlBuilder) {
        if (Objects.nonNull(index.getGlobal())) {
            sqlBuilder.append(index.getGlobal() != false ? " GLOBAL " : " LOCAL ");
        }
        if (Objects.nonNull(index.getKeyBlockSize())) {
            sqlBuilder.append(" KEY_BLOCK_SIZE ").append(String.valueOf(index.getKeyBlockSize()));
        }
        if (index.getType() == DBIndexType.FULLTEXT && StringUtils.isNotBlank((CharSequence)index.getParserName())) {
            sqlBuilder.append(" WITH PARSER ").append(index.getParserName());
        }
        if (StringUtils.isNotBlank((CharSequence)index.getComment())) {
            sqlBuilder.append(" COMMENT ").value(index.getComment());
        }
        if (Objects.nonNull(index.getVisible()) && !index.getVisible().booleanValue()) {
            sqlBuilder.append(" INVISIBLE ");
        }
    }
}

