/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBTableColumnEditor;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

public class OracleColumnEditor
extends DBTableColumnEditor {
    @Override
    protected boolean appendColumnKeyWord() {
        return false;
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }

    @Override
    protected List<DBTableColumnEditor.DBColumnModifier> getSupportColumnModifiers() {
        return Arrays.asList(new OracleDataColumnModifier(), new ExtraInfoModifier(), new DBTableColumnEditor.NullNotNullModifier(), new DefaultOptionModifier());
    }

    @Override
    protected String generateCreateDefinitionForUpdateDDL(DBTableColumn oldColumn, DBTableColumn newColumn) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.identifier(newColumn.getName());
        List<DBTableColumnEditor.DBColumnModifier> columnModifiersForUpdate = this.getSupportColumnModifiers();
        if (Objects.equals(newColumn.getNullable(), oldColumn.getNullable())) {
            columnModifiersForUpdate = columnModifiersForUpdate.stream().filter(m -> !m.getClass().equals(DBTableColumnEditor.NullNotNullModifier.class)).collect(Collectors.toList());
        }
        columnModifiersForUpdate.forEach(modifier -> modifier.appendModifier(newColumn, sqlBuilder));
        return sqlBuilder.toString().trim();
    }

    @Override
    public String generateUpdateObjectDDL(@NotNull DBTableColumn oldColumn, @NotNull DBTableColumn newColumn) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (!StringUtils.equals((CharSequence)oldColumn.getName(), (CharSequence)newColumn.getName())) {
            sqlBuilder.append(this.generateRenameObjectDDL(oldColumn, newColumn)).append(";\n");
        }
        if (!StringUtils.equals((CharSequence)oldColumn.getComment(), (CharSequence)newColumn.getComment())) {
            this.generateColumnComment(newColumn, sqlBuilder);
            oldColumn.setComment(null);
            newColumn.setComment(null);
        }
        if (!Objects.equals(oldColumn, newColumn)) {
            sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(oldColumn)).append(" MODIFY ");
            if (this.appendColumnKeyWord()) {
                sqlBuilder.append("COLUMN ");
            }
            sqlBuilder.append(this.generateCreateDefinitionForUpdateDDL(oldColumn, newColumn)).append(";\n");
        }
        return sqlBuilder.toString();
    }

    @Override
    protected void generateColumnComment(DBTableColumn column, SqlBuilder sqlBuilder) {
        if (Objects.nonNull(column.getComment())) {
            sqlBuilder.append("COMMENT ON COLUMN ").append(this.getFullyQualifiedTableName(column)).append(".").identifier(column.getName()).append(" IS ").value(column.getComment()).append(";").line();
        }
    }

    protected static class DefaultOptionModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected DefaultOptionModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            if (Objects.nonNull(column.getVirtual()) && column.getVirtual().booleanValue()) {
                return;
            }
            String defaultValue = StringUtils.isEmpty((CharSequence)column.getDefaultValue()) ? "NULL" : column.getDefaultValue();
            sqlBuilder.append(" DEFAULT ").append(defaultValue);
        }
    }

    protected static class OracleDataColumnModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected OracleDataColumnModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            String typeName = column.getTypeName();
            Long precision = column.getPrecision();
            Integer scale = column.getScale();
            Integer yearPrecision = column.getYearPrecision();
            Integer dayPrecision = column.getDayPrecision();
            Integer secondPrecision = column.getSecondPrecision();
            if ("INTERVAL YEAR TO MONTH".equalsIgnoreCase(typeName) || "INTERVAL DAY TO SECOND".equalsIgnoreCase(typeName)) {
                if ("INTERVAL YEAR TO MONTH".equalsIgnoreCase(typeName)) {
                    if (Objects.nonNull(yearPrecision)) {
                        sqlBuilder.append(" INTERVAL YEAR(").append(String.valueOf(yearPrecision)).append(") TO MONTH");
                    } else {
                        sqlBuilder.append(" INTERVAL YEAR TO MONTH");
                    }
                }
                if ("INTERVAL DAY TO SECOND".equalsIgnoreCase(typeName)) {
                    if (Objects.isNull(secondPrecision)) {
                        if (Objects.nonNull(dayPrecision)) {
                            sqlBuilder.append(" INTERVAL DAY(").append(String.valueOf(dayPrecision)).append(") TO SECOND");
                        } else {
                            sqlBuilder.append(" INTERVAL DAY TO SECOND");
                        }
                    } else if (Objects.nonNull(dayPrecision)) {
                        sqlBuilder.append(" INTERVAL DAY(").append(String.valueOf(dayPrecision)).append(") TO SECOND(").append(String.valueOf(secondPrecision)).append(")");
                    } else {
                        sqlBuilder.append(" INTERVAL DAY TO SECOND(").append(String.valueOf(secondPrecision)).append(")");
                    }
                }
            } else if (StringUtils.startsWith((CharSequence)typeName, (CharSequence)"TIMESTAMP")) {
                if (Objects.nonNull(secondPrecision)) {
                    String typeNameWithPrecision = typeName.replaceFirst("TIMESTAMP", "TIMESTAMP(" + secondPrecision + ")");
                    sqlBuilder.space().append(typeNameWithPrecision).space();
                } else {
                    sqlBuilder.space().append(typeName).space();
                }
            } else if ("NUMBER".equalsIgnoreCase(typeName)) {
                if (Objects.isNull(precision) && Objects.nonNull(scale)) {
                    sqlBuilder.space().append(typeName).append("(*, ").append(String.valueOf(scale)).append(")");
                } else {
                    new DBTableColumnEditor.DataTypeModifier().appendModifier(column, sqlBuilder);
                }
            } else {
                new DBTableColumnEditor.DataTypeModifier().appendModifier(column, sqlBuilder);
            }
        }
    }

    protected static class ExtraInfoModifier
    implements DBTableColumnEditor.DBColumnModifier {
        protected ExtraInfoModifier() {
        }

        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            if (Objects.nonNull(column.getVirtual()) && column.getVirtual().booleanValue()) {
                if (StringUtils.isEmpty((CharSequence)column.getGenExpression())) {
                    column.setGenExpression("");
                }
                sqlBuilder.append(" AS (").append(column.getGenExpression()).append(")").append(" VIRTUAL ");
            }
        }
    }
}

