/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBSequence;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;

public class OracleSequenceEditor
implements DBObjectEditor<DBSequence> {
    @Override
    public boolean editable() {
        return false;
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBSequence dbObject) {
        Validate.notBlank((CharSequence)dbObject.getName(), (String)"Sequence name can not be blank", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE SEQUENCE ").identifier(dbObject.getName());
        if (dbObject.getMinValue() != null) {
            sqlBuilder.append(" MINVALUE ").append(dbObject.getMinValue());
        } else {
            sqlBuilder.append(" NOMINVALUE");
        }
        if (dbObject.getMaxValue() != null) {
            sqlBuilder.append(" MAXVALUE ").append(dbObject.getMaxValue());
        } else {
            sqlBuilder.append(" NOMAXVALUE");
        }
        if (dbObject.getStartValue() != null) {
            sqlBuilder.append(" START WITH ").append(dbObject.getStartValue());
        }
        if (dbObject.getIncreament() != null) {
            sqlBuilder.append(" INCREMENT BY ").append(dbObject.getIncreament());
        }
        if (dbObject.getCached() != null) {
            if (dbObject.getCached().booleanValue() && dbObject.getCacheSize() != null) {
                sqlBuilder.append(" CACHE ").append(dbObject.getCacheSize());
            } else {
                sqlBuilder.append(" NOCACHE");
            }
        }
        if (dbObject.getOrderd() != null) {
            if (dbObject.getOrderd().booleanValue()) {
                sqlBuilder.append(" ORDER");
            } else {
                sqlBuilder.append(" NOORDER");
            }
        }
        if (dbObject.getCycled() != null) {
            if (dbObject.getCycled().booleanValue()) {
                sqlBuilder.append(" CYCLE");
            } else {
                sqlBuilder.append(" NOCYCLE");
            }
        }
        return sqlBuilder.append(";").toString();
    }

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBSequence dbObject) {
        return this.generateCreateObjectDDL(dbObject);
    }

    @Override
    public String generateUpdateObjectDDL(@NotNull DBSequence oldObject, @NotNull DBSequence newObject) {
        Validate.notBlank((CharSequence)oldObject.getName(), (String)"Sequence name can not be blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)oldObject.getName(), (CharSequence)newObject.getName()));
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("ALTER SEQUENCE ").identifier(oldObject.getName());
        if (newObject.getMinValue() != null) {
            sqlBuilder.append(" MINVALUE ").append(newObject.getMinValue());
        } else {
            sqlBuilder.append(" NOMINVALUE");
        }
        if (newObject.getMaxValue() != null) {
            sqlBuilder.append(" MAXVALUE ").append(newObject.getMaxValue());
        } else {
            sqlBuilder.append(" NOMAXVALUE");
        }
        if (newObject.getIncreament() != null) {
            sqlBuilder.append(" INCREMENT BY ").append(newObject.getIncreament());
        }
        if (newObject.getCached() != null) {
            if (newObject.getCached().booleanValue() && newObject.getCacheSize() != null) {
                sqlBuilder.append(" CACHE ").append(newObject.getCacheSize());
            } else {
                sqlBuilder.append(" NOCACHE");
            }
        }
        if (newObject.getOrderd() != null) {
            if (newObject.getOrderd().booleanValue()) {
                sqlBuilder.append(" ORDER");
            } else {
                sqlBuilder.append(" NOORDER");
            }
        }
        if (newObject.getCycled() != null) {
            if (newObject.getCycled().booleanValue()) {
                sqlBuilder.append(" CYCLE");
            } else {
                sqlBuilder.append(" NOCYCLE");
            }
        }
        return sqlBuilder.append(";").toString();
    }

    @Override
    public String generateUpdateObjectListDDL(Collection<DBSequence> oldObjects, Collection<DBSequence> newObjects) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBSequence oldObject, @NotNull DBSequence newObject) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBSequence dbObject) {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

