/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model;

import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import java.util.List;

public class DBColumnGroupElement {
    private boolean allColumns;
    private boolean eachColumn;
    private String groupName;
    private List<String> columnNames;

    public static DBColumnGroupElement ofColumnGroupElement(ColumnGroupElement e) {
        DBColumnGroupElement group = new DBColumnGroupElement();
        if (e.isAllColumns()) {
            group.setAllColumns(true);
        } else if (e.isEachColumn()) {
            group.setEachColumn(true);
        } else {
            group.setGroupName(e.getGroupName());
            group.setColumnNames(e.getColumnNames());
        }
        return group;
    }

    public String toString() {
        if (this.isAllColumns()) {
            return "all columns";
        }
        if (this.isEachColumn()) {
            return "each column";
        }
        return String.format("%s(%s)", this.groupName, String.join((CharSequence)",", this.columnNames));
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public boolean isEachColumn() {
        return this.eachColumn;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }

    public void setEachColumn(boolean eachColumn) {
        this.eachColumn = eachColumn;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBColumnGroupElement)) {
            return false;
        }
        DBColumnGroupElement other = (DBColumnGroupElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllColumns() != other.isAllColumns()) {
            return false;
        }
        if (this.isEachColumn() != other.isEachColumn()) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        return !(this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBColumnGroupElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllColumns() ? 79 : 97);
        result = result * 59 + (this.isEachColumn() ? 79 : 97);
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        return result;
    }
}

