/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model;

import com.oceanbase.tools.dbbrowser.model.DBObject;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBPackageDetail;
import com.oceanbase.tools.dbbrowser.util.StringUtils;

public class DBPackage
implements DBObject {
    private String packageName;
    private String packageType;
    private DBPackageDetail packageHead;
    private DBPackageDetail packageBody;
    private String status = "VALID";
    private String errorMessage;

    public static DBPackage ofPackage(String name) {
        DBPackage dbPackage = new DBPackage();
        dbPackage.packageName = name;
        dbPackage.packageType = DBObjectType.PACKAGE.getName();
        return dbPackage;
    }

    public static DBPackage ofPackageBody(String name) {
        DBPackage dbPackage = DBPackage.ofPackage(name);
        dbPackage.packageType = DBObjectType.PACKAGE_BODY.getName();
        return dbPackage;
    }

    @Override
    public String name() {
        return this.packageName;
    }

    @Override
    public DBObjectType type() {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)this.packageType, (CharSequence[])new CharSequence[]{"packageBody"})) {
            return DBObjectType.PACKAGE_BODY;
        }
        return DBObjectType.getEnumByName(this.packageType);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public DBPackageDetail getPackageHead() {
        return this.packageHead;
    }

    public DBPackageDetail getPackageBody() {
        return this.packageBody;
    }

    public String getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    public void setPackageHead(DBPackageDetail packageHead) {
        this.packageHead = packageHead;
    }

    public void setPackageBody(DBPackageDetail packageBody) {
        this.packageBody = packageBody;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBPackage)) {
            return false;
        }
        DBPackage other = (DBPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$packageType = this.getPackageType();
        String other$packageType = other.getPackageType();
        if (this$packageType == null ? other$packageType != null : !this$packageType.equals(other$packageType)) {
            return false;
        }
        DBPackageDetail this$packageHead = this.getPackageHead();
        DBPackageDetail other$packageHead = other.getPackageHead();
        if (this$packageHead == null ? other$packageHead != null : !((Object)this$packageHead).equals(other$packageHead)) {
            return false;
        }
        DBPackageDetail this$packageBody = this.getPackageBody();
        DBPackageDetail other$packageBody = other.getPackageBody();
        if (this$packageBody == null ? other$packageBody != null : !((Object)this$packageBody).equals(other$packageBody)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $packageType = this.getPackageType();
        result = result * 59 + ($packageType == null ? 43 : $packageType.hashCode());
        DBPackageDetail $packageHead = this.getPackageHead();
        result = result * 59 + ($packageHead == null ? 43 : ((Object)$packageHead).hashCode());
        DBPackageDetail $packageBody = this.getPackageBody();
        result = result * 59 + ($packageBody == null ? 43 : ((Object)$packageBody).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "DBPackage(packageName=" + this.getPackageName() + ", packageType=" + this.getPackageType() + ", packageHead=" + this.getPackageHead() + ", packageBody=" + this.getPackageBody() + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ")";
    }
}

