/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model;

import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import org.apache.commons.lang3.StringUtils;

public class DBTableAbstractPartitionDefinition {
    private String name;
    @NotNull
    private DBTablePartitionType type;
    private List<String> maxValues;
    private List<List<String>> valuesList;
    private String comment;
    @Positive
    private Long maxRows;
    @Positive
    private Long minRows;
    private Integer ordinalPosition;
    private String dataDirectory;
    private String indexDirectory;

    public void fillValues(String description) {
        if (StringUtils.isNotBlank((CharSequence)description)) {
            if (this.type == DBTablePartitionType.LIST_COLUMNS || this.type == DBTablePartitionType.LIST) {
                this.setValuesList(DBSchemaAccessorUtil.parseListRangePartitionDescription(description));
            } else if (this.type == DBTablePartitionType.RANGE || this.type == DBTablePartitionType.HASH) {
                this.setMaxValues(Arrays.asList(description));
            } else {
                this.setMaxValues(Arrays.asList(StringUtils.split((String)description, (String)",")));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public DBTablePartitionType getType() {
        return this.type;
    }

    public List<String> getMaxValues() {
        return this.maxValues;
    }

    public List<List<String>> getValuesList() {
        return this.valuesList;
    }

    public String getComment() {
        return this.comment;
    }

    public Long getMaxRows() {
        return this.maxRows;
    }

    public Long getMinRows() {
        return this.minRows;
    }

    public Integer getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(DBTablePartitionType type) {
        this.type = type;
    }

    public void setMaxValues(List<String> maxValues) {
        this.maxValues = maxValues;
    }

    public void setValuesList(List<List<String>> valuesList) {
        this.valuesList = valuesList;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setMaxRows(Long maxRows) {
        this.maxRows = maxRows;
    }

    public void setMinRows(Long minRows) {
        this.minRows = minRows;
    }

    public void setOrdinalPosition(Integer ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String toString() {
        return "DBTableAbstractPartitionDefinition(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", maxValues=" + this.getMaxValues() + ", valuesList=" + this.getValuesList() + ", comment=" + this.getComment() + ", maxRows=" + this.getMaxRows() + ", minRows=" + this.getMinRows() + ", ordinalPosition=" + this.getOrdinalPosition() + ", dataDirectory=" + this.getDataDirectory() + ", indexDirectory=" + this.getIndexDirectory() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBTableAbstractPartitionDefinition)) {
            return false;
        }
        DBTableAbstractPartitionDefinition other = (DBTableAbstractPartitionDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DBTablePartitionType this$type = this.getType();
        DBTablePartitionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$maxValues = this.getMaxValues();
        List<String> other$maxValues = other.getMaxValues();
        if (this$maxValues == null ? other$maxValues != null : !((Object)this$maxValues).equals(other$maxValues)) {
            return false;
        }
        List<List<String>> this$valuesList = this.getValuesList();
        List<List<String>> other$valuesList = other.getValuesList();
        if (this$valuesList == null ? other$valuesList != null : !((Object)this$valuesList).equals(other$valuesList)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Long this$maxRows = this.getMaxRows();
        Long other$maxRows = other.getMaxRows();
        if (this$maxRows == null ? other$maxRows != null : !((Object)this$maxRows).equals(other$maxRows)) {
            return false;
        }
        Long this$minRows = this.getMinRows();
        Long other$minRows = other.getMinRows();
        if (this$minRows == null ? other$minRows != null : !((Object)this$minRows).equals(other$minRows)) {
            return false;
        }
        String this$dataDirectory = this.getDataDirectory();
        String other$dataDirectory = other.getDataDirectory();
        if (this$dataDirectory == null ? other$dataDirectory != null : !this$dataDirectory.equals(other$dataDirectory)) {
            return false;
        }
        String this$indexDirectory = this.getIndexDirectory();
        String other$indexDirectory = other.getIndexDirectory();
        return !(this$indexDirectory == null ? other$indexDirectory != null : !this$indexDirectory.equals(other$indexDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBTableAbstractPartitionDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DBTablePartitionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $maxValues = this.getMaxValues();
        result = result * 59 + ($maxValues == null ? 43 : ((Object)$maxValues).hashCode());
        List<List<String>> $valuesList = this.getValuesList();
        result = result * 59 + ($valuesList == null ? 43 : ((Object)$valuesList).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Long $maxRows = this.getMaxRows();
        result = result * 59 + ($maxRows == null ? 43 : ((Object)$maxRows).hashCode());
        Long $minRows = this.getMinRows();
        result = result * 59 + ($minRows == null ? 43 : ((Object)$minRows).hashCode());
        String $dataDirectory = this.getDataDirectory();
        result = result * 59 + ($dataDirectory == null ? 43 : $dataDirectory.hashCode());
        String $indexDirectory = this.getIndexDirectory();
        result = result * 59 + ($indexDirectory == null ? 43 : $indexDirectory.hashCode());
        return result;
    }
}

