/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model.datatype;

import com.oceanbase.tools.dbbrowser.model.datatype.DataType;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class DataTypeUtil {
    private static final String[] BINARY_DATA_TYPES = new String[]{"blob", "clob", "raw", "longblob", "mediumblob", "tinyblob"};
    private static final String RAW_DATA_TYPES = "raw";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");
    private static final String[] STRING_DATA_TYPES = new String[]{"char", "varchar", "varchar2", "tinytext", "mediumtext", "longtext", "text", "NCHAR", "NVARCHAR", "NVARCHAR2", "CHARACTER"};
    private static final String[] INTEGER_DATA_TYPES = new String[]{"tinyint", "smallint", "mediumint", "int", "integer", "bigint"};
    private static final String[] DATE_DATA_TYPES = new String[]{"date", "time", "datetime", "timestamp", "year"};
    private static final String[] PL_BASIC_DATA_TYPES = new String[]{"BOOL", "BOOLEAN", "PLS_INTEGER", "BINARY_INTEGER", "NATURAL", "NATURALN", "POSITIVE", "POSITIVEN", "SIGNTYPE", "SIMPLE_INTEGER", "MEDIUMINT", "number", "binary_double", "simple_double", "binary_float", "simple_float", "urowid", "numeric", "double", "float", "rowid", "blob", "clob", "raw", "longblob", "mediumblob", "tinyblob", "char", "varchar", "varchar2", "tinytext", "mediumtext", "longtext", "text", "NCHAR", "NVARCHAR", "NVARCHAR2", "CHARACTER", "tinyint", "smallint", "mediumint", "int", "integer", "bigint", "date", "time", "datetime", "timestamp", "year", "raw"};

    public static boolean isBinaryType(String dataTypeName) {
        for (String type : BINARY_DATA_TYPES) {
            if (!type.equalsIgnoreCase(dataTypeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStringType(String dataTypeName) {
        for (String type : STRING_DATA_TYPES) {
            if (!type.equalsIgnoreCase(dataTypeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntegerType(String dataTypeName) {
        for (String type : INTEGER_DATA_TYPES) {
            if (!type.equalsIgnoreCase(dataTypeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateType(String dataTypeName) {
        for (String type : DATE_DATA_TYPES) {
            if (!type.equalsIgnoreCase(dataTypeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRawType(String dataTypeName) {
        return RAW_DATA_TYPES.equalsIgnoreCase(dataTypeName);
    }

    public static boolean isBinaryType(DataType dataType) {
        return DataTypeUtil.isBinaryType(dataType.getDataTypeName());
    }

    public static boolean isRawType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return DataTypeUtil.isRawType(dataType.getDataTypeName());
    }

    public static boolean isBitType(String dataTypeName) {
        return StringUtils.containsIgnoreCase((CharSequence)dataTypeName, (CharSequence)"BIT");
    }

    public static boolean isBitType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return DataTypeUtil.isBitType(dataType.getDataTypeName());
    }

    public static boolean isDateType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return StringUtils.containsIgnoreCase((CharSequence)dataType.getDataTypeName(), (CharSequence)"DATE");
    }

    public static boolean isNumericValue(String value) {
        if (null == value) {
            return false;
        }
        return NUMBER_PATTERN.matcher(value).matches();
    }

    public static boolean isExtType(String dataType) {
        for (String type : PL_BASIC_DATA_TYPES) {
            if (!type.equalsIgnoreCase(dataType)) continue;
            return false;
        }
        return true;
    }
}

