/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model.datatype;

import com.oceanbase.tools.dbbrowser.model.datatype.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class GeneralDataType
implements DataType {
    private final int precision;
    private final int scale;
    private final String columnTypeName;

    public GeneralDataType(int precision, int scale, @NonNull String dataTypeName) {
        if (dataTypeName == null) {
            throw new NullPointerException("dataTypeName is marked non-null but is null");
        }
        this.precision = precision;
        this.scale = scale;
        this.columnTypeName = dataTypeName;
    }

    public GeneralDataType(int precision, String dataTypeName) {
        this(precision, 0, dataTypeName);
    }

    public GeneralDataType(String dataTypeName) {
        this(0, 0, dataTypeName);
    }

    public GeneralDataType(@NonNull ResultSetMetaData metaData, int columnIndex) throws SQLException {
        if (metaData == null) {
            throw new NullPointerException("metaData is marked non-null but is null");
        }
        Validate.isTrue((columnIndex >= 0 ? 1 : 0) != 0, (String)"ColumnIndex can not be negative", (Object[])new Object[0]);
        this.precision = metaData.getPrecision(columnIndex + 1);
        this.scale = metaData.getScale(columnIndex + 1);
        this.columnTypeName = metaData.getColumnTypeName(columnIndex + 1);
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public String getDataTypeName() {
        return this.columnTypeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralDataType)) {
            return false;
        }
        GeneralDataType other = (GeneralDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        String this$columnTypeName = this.columnTypeName;
        String other$columnTypeName = other.columnTypeName;
        return !(this$columnTypeName == null ? other$columnTypeName != null : !this$columnTypeName.equals(other$columnTypeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        String $columnTypeName = this.columnTypeName;
        result = result * 59 + ($columnTypeName == null ? 43 : $columnTypeName.hashCode());
        return result;
    }
}

