/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import lombok.NonNull;

class CacheElement<T> {
    private final T value;
    private final Exception exception;

    public CacheElement(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.exception = null;
        this.value = value;
    }

    public CacheElement(@NonNull Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.value = null;
        this.exception = exception;
    }

    public T get() {
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }
        return this.value;
    }
}

