/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.result;

import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.parser.constant.SqlType;
import com.oceanbase.tools.dbbrowser.parser.listener.BasicParserListener;
import java.util.HashSet;
import java.util.List;

public class BasicResult {
    private SqlType sqlType;
    private DBObjectType dbObjectType;
    private List<String> dbObjectNameList;
    private Boolean syntaxError;

    public BasicResult(BasicParserListener listener) {
        this.sqlType = listener.getSqlType();
        this.dbObjectType = listener.getDbObjectType();
        this.dbObjectNameList = listener.getDbObjectNameList();
    }

    public BasicResult(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public boolean isPlDdl() {
        if (this.sqlType != SqlType.CREATE) {
            return false;
        }
        HashSet<DBObjectType> plTypes = new HashSet<DBObjectType>();
        plTypes.add(DBObjectType.PROCEDURE);
        plTypes.add(DBObjectType.FUNCTION);
        plTypes.add(DBObjectType.PACKAGE);
        plTypes.add(DBObjectType.PACKAGE_BODY);
        plTypes.add(DBObjectType.TRIGGER);
        plTypes.add(DBObjectType.TYPE);
        plTypes.add(DBObjectType.ANONYMOUS_BLOCK);
        return plTypes.contains((Object)this.dbObjectType);
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public DBObjectType getDbObjectType() {
        return this.dbObjectType;
    }

    public List<String> getDbObjectNameList() {
        return this.dbObjectNameList;
    }

    public Boolean getSyntaxError() {
        return this.syntaxError;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public void setDbObjectType(DBObjectType dbObjectType) {
        this.dbObjectType = dbObjectType;
    }

    public void setDbObjectNameList(List<String> dbObjectNameList) {
        this.dbObjectNameList = dbObjectNameList;
    }

    public void setSyntaxError(Boolean syntaxError) {
        this.syntaxError = syntaxError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicResult)) {
            return false;
        }
        BasicResult other = (BasicResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SqlType this$sqlType = this.getSqlType();
        SqlType other$sqlType = other.getSqlType();
        if (this$sqlType == null ? other$sqlType != null : !((Object)((Object)this$sqlType)).equals((Object)other$sqlType)) {
            return false;
        }
        DBObjectType this$dbObjectType = this.getDbObjectType();
        DBObjectType other$dbObjectType = other.getDbObjectType();
        if (this$dbObjectType == null ? other$dbObjectType != null : !((Object)((Object)this$dbObjectType)).equals((Object)other$dbObjectType)) {
            return false;
        }
        List<String> this$dbObjectNameList = this.getDbObjectNameList();
        List<String> other$dbObjectNameList = other.getDbObjectNameList();
        if (this$dbObjectNameList == null ? other$dbObjectNameList != null : !((Object)this$dbObjectNameList).equals(other$dbObjectNameList)) {
            return false;
        }
        Boolean this$syntaxError = this.getSyntaxError();
        Boolean other$syntaxError = other.getSyntaxError();
        return !(this$syntaxError == null ? other$syntaxError != null : !((Object)this$syntaxError).equals(other$syntaxError));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SqlType $sqlType = this.getSqlType();
        result = result * 59 + ($sqlType == null ? 43 : ((Object)((Object)$sqlType)).hashCode());
        DBObjectType $dbObjectType = this.getDbObjectType();
        result = result * 59 + ($dbObjectType == null ? 43 : ((Object)((Object)$dbObjectType)).hashCode());
        List<String> $dbObjectNameList = this.getDbObjectNameList();
        result = result * 59 + ($dbObjectNameList == null ? 43 : ((Object)$dbObjectNameList).hashCode());
        Boolean $syntaxError = this.getSyntaxError();
        result = result * 59 + ($syntaxError == null ? 43 : ((Object)$syntaxError).hashCode());
        return result;
    }

    public String toString() {
        return "BasicResult(sqlType=" + (Object)((Object)this.getSqlType()) + ", dbObjectType=" + (Object)((Object)this.getDbObjectType()) + ", dbObjectNameList=" + this.getDbObjectNameList() + ", syntaxError=" + this.getSyntaxError() + ")";
    }
}

