/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser.result;

import com.oceanbase.tools.dbbrowser.model.DBIndex;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.parser.listener.MysqlModeSqlParserListener;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModeSqlParserListener;
import com.oceanbase.tools.dbbrowser.parser.result.BasicResult;
import java.util.List;

public class ParseSqlResult
extends BasicResult {
    private boolean selectStmt;
    private boolean withForUpdate;
    private boolean limitClause;
    private List<MysqlModeSqlParserListener.ColumnDefinition> columns;
    private boolean fetchClause;
    private boolean whereClause;
    private List<DBIndex> indexes;
    private List<DBTableConstraint> foreignConstraint;

    public ParseSqlResult(OracleModeSqlParserListener listener) {
        super(listener);
        this.selectStmt = listener.isSelectStmt();
        this.withForUpdate = listener.isWithForUpdate();
        this.fetchClause = listener.isFetchNext();
        this.whereClause = listener.isWhereClause();
        this.indexes = listener.getIndexes();
        this.foreignConstraint = listener.getForeignConstraint();
    }

    public ParseSqlResult(MysqlModeSqlParserListener listener) {
        super(listener);
        this.selectStmt = listener.isSelectStmt();
        this.withForUpdate = listener.isWithForUpdate();
        this.limitClause = listener.isLimitClause();
        this.indexes = listener.getIndexes();
        this.columns = listener.getColumns();
        this.foreignConstraint = listener.getForeignConstraint();
    }

    public boolean isSupportLimit() {
        return this.selectStmt && !this.withForUpdate;
    }

    public boolean isSupportAddROWID() {
        return this.selectStmt;
    }

    public boolean isSelectStmt() {
        return this.selectStmt;
    }

    public boolean isWithForUpdate() {
        return this.withForUpdate;
    }

    public boolean isLimitClause() {
        return this.limitClause;
    }

    public List<MysqlModeSqlParserListener.ColumnDefinition> getColumns() {
        return this.columns;
    }

    public boolean isFetchClause() {
        return this.fetchClause;
    }

    public boolean isWhereClause() {
        return this.whereClause;
    }

    public List<DBIndex> getIndexes() {
        return this.indexes;
    }

    public List<DBTableConstraint> getForeignConstraint() {
        return this.foreignConstraint;
    }

    public void setSelectStmt(boolean selectStmt) {
        this.selectStmt = selectStmt;
    }

    public void setWithForUpdate(boolean withForUpdate) {
        this.withForUpdate = withForUpdate;
    }

    public void setLimitClause(boolean limitClause) {
        this.limitClause = limitClause;
    }

    public void setColumns(List<MysqlModeSqlParserListener.ColumnDefinition> columns) {
        this.columns = columns;
    }

    public void setFetchClause(boolean fetchClause) {
        this.fetchClause = fetchClause;
    }

    public void setWhereClause(boolean whereClause) {
        this.whereClause = whereClause;
    }

    public void setIndexes(List<DBIndex> indexes) {
        this.indexes = indexes;
    }

    public void setForeignConstraint(List<DBTableConstraint> foreignConstraint) {
        this.foreignConstraint = foreignConstraint;
    }
}

