/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.mysql;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBRoutineDataNature;
import com.oceanbase.tools.dbbrowser.template.mysql.BaseMySQLPLTemplate;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class MySQLFunctionTemplate
extends BaseMySQLPLTemplate<DBFunction> {
    @Override
    public String generateCreateObjectTemplate(@NotNull DBFunction dbObject) {
        Validate.notBlank((CharSequence)dbObject.getFunName(), (String)"Function name can not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbObject.getReturnType(), (String)"Function return type can not be blank", (Object[])new Object[0]);
        MySQLSqlBuilder sqlBuilder = new MySQLSqlBuilder();
        sqlBuilder.append("create function ").identifier(dbObject.getFunName()).append("(");
        List<DBPLParam> paramList = dbObject.getParams();
        if (CollectionUtils.isNotEmpty(paramList)) {
            sqlBuilder.append(paramList.stream().map(p -> "\n\t" + p.getParamName() + " " + p.getDataType()).collect(Collectors.joining(",")));
        }
        sqlBuilder.append(")").append("\nreturns ").append(dbObject.getReturnType()).line();
        if (Objects.nonNull(dbObject.getCharacteristic())) {
            if (Objects.nonNull(dbObject.getCharacteristic().getComment())) {
                sqlBuilder.space().append("COMMENT ").value(dbObject.getCharacteristic().getComment()).line();
            }
            if (Objects.nonNull(dbObject.getCharacteristic().getDeterministic()) && dbObject.getCharacteristic().getDeterministic().booleanValue()) {
                sqlBuilder.space().append("DETERMINISTIC").line();
            }
            if (Objects.nonNull((Object)dbObject.getCharacteristic().getDataNature())) {
                switch (dbObject.getCharacteristic().getDataNature()) {
                    case CONTAINS_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.CONTAINS_SQL.getValue()).line();
                        break;
                    }
                    case NO_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.NO_SQL.getValue()).line();
                        break;
                    }
                    case READS_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.READS_SQL.getValue()).line();
                        break;
                    }
                    case MODIFIES_SQL: {
                        sqlBuilder.space().append(DBRoutineDataNature.MODIFIES_SQL.getValue()).line();
                    }
                }
            }
            if (Objects.nonNull((Object)dbObject.getCharacteristic().getSqlSecurity())) {
                sqlBuilder.space().append("SQL SECURITY ").append((Object)dbObject.getCharacteristic().getSqlSecurity()).line();
            }
        }
        sqlBuilder.append("begin").line().append("\t-- Enter your function code").line().append("end");
        return sqlBuilder.toString();
    }
}

