/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.oracle;

import com.oceanbase.tools.dbbrowser.model.DBFunction;
import com.oceanbase.tools.dbbrowser.model.DBPLParam;
import com.oceanbase.tools.dbbrowser.model.DBPLParamMode;
import com.oceanbase.tools.dbbrowser.template.oracle.BaseOraclePLTemplate;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class OracleFunctionTemplate
extends BaseOraclePLTemplate<DBFunction> {
    @Override
    public String generateCreateObjectTemplate(@NotNull DBFunction dbObject) {
        Validate.notBlank((CharSequence)dbObject.getFunName(), (String)"Function name can not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbObject.getReturnType(), (String)"Function return type can not be blank", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE FUNCTION ").identifier(dbObject.getFunName());
        List<DBPLParam> paramList = dbObject.getParams();
        if (CollectionUtils.isNotEmpty(paramList)) {
            String params = paramList.stream().map(p -> {
                StringBuilder strBuilder = new StringBuilder();
                DBPLParamMode type = p.getParamMode();
                String defaultValue = p.getDefaultValue();
                strBuilder.append("\n\t").append(p.getParamName()).append(" ").append(this.generateInOutString(type)).append(" ").append(p.getDataType());
                if (StringUtils.isNotBlank((CharSequence)defaultValue) && DBPLParamMode.IN == type) {
                    strBuilder.append(" DEFAULT ").append(StringUtils.quoteOracleValue(defaultValue));
                }
                return strBuilder.toString();
            }).collect(Collectors.joining(","));
            sqlBuilder.append("(").append(params).append(")");
        }
        sqlBuilder.append("\nRETURN ").append(dbObject.getReturnType()).append(" AS\n\tV1 INT;").append("\nBEGIN").append("\n\t-- Enter your function code").append("\nEND");
        return sqlBuilder.toString();
    }
}

