/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.template.oracle;

import com.oceanbase.tools.dbbrowser.model.DBTrigger;
import com.oceanbase.tools.dbbrowser.model.DBTriggerReference;
import com.oceanbase.tools.dbbrowser.template.DBObjectTemplate;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class OracleTriggerTemplate
implements DBObjectTemplate<DBTrigger> {
    @Override
    public String generateCreateObjectTemplate(@NotNull DBTrigger dbObject) {
        Validate.notBlank((CharSequence)dbObject.getTriggerName(), (String)"Trigger name can not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)dbObject.getTriggerMode()), (String)"Trigger mode can not be null", (Object[])new Object[0]);
        Validate.notEmpty(dbObject.getTriggerEvents(), (String)"Trigger events can not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbObject.getSchemaName(), (String)"Schema name can not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dbObject.getSchemaMode(), (String)"Schema mode can not be blank", (Object[])new Object[0]);
        OracleSqlBuilder sqlBuilder = new OracleSqlBuilder();
        sqlBuilder.append("CREATE OR REPLACE TRIGGER ").identifier(dbObject.getTriggerName()).append(" ").append(dbObject.getTriggerMode().name());
        String events = dbObject.getTriggerEvents().stream().map(event -> {
            StringBuilder builder = new StringBuilder();
            builder.append(event.getDmlEvent().name());
            String column = event.getColumn();
            if (StringUtils.isNotBlank((CharSequence)column)) {
                builder.append(" OF ").append(StringUtils.quoteOracleIdentifier(column));
            }
            return builder.toString();
        }).collect(Collectors.joining(" OR "));
        sqlBuilder.append("\n\t").append(events).append(" ON ").identifier(dbObject.getSchemaName());
        List<DBTriggerReference> references = dbObject.getReferences();
        if (CollectionUtils.isNotEmpty(references)) {
            String refers = references.stream().map(r -> r.getReferenceType().name() + " AS " + r.getReferName()).collect(Collectors.joining(" "));
            sqlBuilder.append("\n\tREFERENCING ").append(refers);
        }
        if (dbObject.getRowLevel().booleanValue()) {
            sqlBuilder.append("\n\tFOR EACH ROW");
        }
        if (dbObject.isEnable()) {
            sqlBuilder.append("\n\tENABLE");
        } else {
            sqlBuilder.append("\n\tDISABLE");
        }
        if (StringUtils.isNotBlank((CharSequence)dbObject.getSqlExpression())) {
            sqlBuilder.append("\n\tWHEN (").append(dbObject.getSqlExpression()).append(")");
        }
        return sqlBuilder.append("\nBEGIN\n\t --your trigger body\nEND;").toString();
    }
}

