/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import com.alibaba.fastjson.JSON;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBObjectWarningDescriptor;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSchemaAccessorUtil {
    private static final Logger log = LoggerFactory.getLogger(DBSchemaAccessorUtil.class);
    public static final int OB_MAX_IN_SIZE = 2000;

    public static void parseCreateOptions(DBTable.DBTableOptions tableOptions, String createOptions) {
        if (StringUtils.contains((CharSequence)createOptions, (CharSequence)"ROW_FORMAT = ")) {
            tableOptions.setRowFormat(createOptions.split("ROW_FORMAT = ")[1].split(" ")[0]);
        }
        if (StringUtils.contains((CharSequence)createOptions, (CharSequence)"COMPRESSION = ")) {
            tableOptions.setCompressionOption(createOptions.split("COMPRESSION = ")[1].split(" ")[0]);
        }
        if (StringUtils.contains((CharSequence)createOptions, (CharSequence)"REPLICA_NUM = ")) {
            tableOptions.setReplicaNum(Integer.valueOf(createOptions.split("REPLICA_NUM = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)createOptions, (CharSequence)"BLOCK_SIZE = ")) {
            tableOptions.setBlockSize(Integer.valueOf(createOptions.split("BLOCK_SIZE = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)createOptions, (CharSequence)"USE_BLOOM_FILTER = ")) {
            tableOptions.setUseBloomFilter("TRUE".equals(createOptions.split("USE_BLOOM_FILTER = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)createOptions, (CharSequence)"TABLET_SIZE = ")) {
            tableOptions.setTabletSize(Long.valueOf(createOptions.split("TABLET_SIZE = ")[1].split(" ")[0]));
        }
    }

    public static List<List<String>> parseListRangePartitionDescription(@NotBlank String description) {
        ArrayList<List<String>> valuesList = new ArrayList<List<String>>();
        try {
            String[] values;
            if (StringUtils.startsWith((CharSequence)description, (CharSequence)"(")) {
                String jsonStr = "[".concat(description).concat("]");
                jsonStr = StringUtils.replace((String)jsonStr, (String)"(", (String)"[");
                String[][] valuesArrays = (String[][])JSON.parseObject((String)(jsonStr = StringUtils.replace((String)jsonStr, (String)")", (String)"]")), String[][].class);
                if (Objects.isNull(valuesArrays)) {
                    return valuesList;
                }
                return Arrays.stream(valuesArrays).map(Arrays::asList).collect(Collectors.toList());
            }
            for (String value : values = description.split(",")) {
                valuesList.add(Arrays.asList(value));
            }
        }
        catch (Exception ex) {
            log.warn("parse list range description from metadata failed, ex=", (Throwable)ex);
        }
        return valuesList;
    }

    public static String parseListRangeValuesList(@NotNull List<List<String>> valuesList) {
        if (CollectionUtils.isEmpty(valuesList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> singleList = new ArrayList<String>();
        try {
            for (int i = 0; i < valuesList.size(); ++i) {
                singleList.add(String.join((CharSequence)",", (Iterable<? extends CharSequence>)valuesList.get(i)));
            }
            for (int j = 0; j < singleList.size(); ++j) {
                if (CollectionUtils.isEmpty((Collection)valuesList.get(j)) || valuesList.get(j).size() <= 1) continue;
                singleList.set(j, "(".concat((String)singleList.get(j)).concat(")"));
            }
            sb.append(String.join((CharSequence)",", singleList));
        }
        catch (Exception ex) {
            log.warn("parse list range valuesList failed, ex=", (Throwable)ex);
        }
        return sb.toString();
    }

    public static String normalizeTypeName(String allTypeName) {
        int modEnd;
        int modIndex;
        if (StringUtils.isEmpty((CharSequence)allTypeName)) {
            return "";
        }
        while ((modIndex = allTypeName.indexOf(40)) != -1 && (modEnd = allTypeName.indexOf(41, modIndex)) != -1) {
            allTypeName = allTypeName.substring(0, modIndex) + (modEnd == allTypeName.length() - 1 ? "" : allTypeName.substring(modEnd + 1));
        }
        return allTypeName;
    }

    public static String parsePrecisionAndScale(String allTypeName) {
        if (StringUtils.isEmpty((CharSequence)allTypeName)) {
            return "";
        }
        String value = "";
        int modIndex = allTypeName.indexOf(40);
        if (modIndex == -1) {
            return value;
        }
        int modEnd = allTypeName.indexOf(41, modIndex);
        if (modEnd == -1) {
            return value;
        }
        if (modIndex + 1 > modEnd) {
            return value;
        }
        value = allTypeName.substring(modIndex + 1, modEnd);
        return value;
    }

    public static void obtainOptionsByParse(DBTable.DBTableOptions tableOptions, String ddl) {
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"ROW_FORMAT = ")) {
            tableOptions.setRowFormat(ddl.split("ROW_FORMAT = ")[1].split(" ")[0]);
        }
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"COMPRESSION = ")) {
            tableOptions.setCompressionOption(ddl.split("COMPRESSION = ")[1].split(" ")[0]);
        }
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"REPLICA_NUM = ")) {
            tableOptions.setReplicaNum(Integer.valueOf(ddl.split("REPLICA_NUM = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"BLOCK_SIZE = ")) {
            tableOptions.setBlockSize(Integer.valueOf(ddl.split("BLOCK_SIZE = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"USE_BLOOM_FILTER = ")) {
            tableOptions.setUseBloomFilter("TRUE".equals(ddl.split("USE_BLOOM_FILTER = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"TABLET_SIZE = ")) {
            tableOptions.setTabletSize(Long.valueOf(ddl.split("TABLET_SIZE = ")[1].split(" ")[0]));
        }
        if (StringUtils.contains((CharSequence)ddl, (CharSequence)"CHARSET = ")) {
            tableOptions.setCharsetName(ddl.split("CHARSET = ")[1].split(" ")[0]);
        }
    }

    public static List<String> parseEnumValues(String typeName) {
        int startPos;
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder value = new StringBuilder();
        int pos = 0;
        while ((startPos = typeName.indexOf(39, pos)) >= 0) {
            int endPos = -1;
            for (int i = startPos + 1; i < typeName.length(); ++i) {
                char c = typeName.charAt(i);
                if (c == '\'') {
                    if (i < typeName.length() - 2 && typeName.charAt(i + 1) == '\'') {
                        value.append(c);
                        ++i;
                        continue;
                    }
                    endPos = i;
                    break;
                }
                value.append(c);
            }
            if (endPos < 0) break;
            values.add(value.toString());
            pos = endPos + 1;
            value.setLength(0);
        }
        return values;
    }

    public static <T extends DBObjectWarningDescriptor> void fillWarning(T dbObjectWarningDescriptor, DBObjectType type, String reason) {
        Validate.notNull(dbObjectWarningDescriptor, (String)"dbObjectWarningDescriptor", (Object[])new Object[0]);
        dbObjectWarningDescriptor.setWarning(String.format("%s maybe not accurate due to %s", type.name(), reason));
    }

    public static <Y, E> List<E> partitionFind(List<Y> filterValues, int partitionSize, @NonNull Function<List<Y>, List<E>> queryMethod) {
        if (queryMethod == null) {
            throw new NullPointerException("queryMethod is marked non-null but is null");
        }
        if (CollectionUtils.isEmpty(filterValues)) {
            return queryMethod.apply(filterValues);
        }
        return ListUtils.partition(filterValues, (int)partitionSize).stream().map(queryMethod).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

