/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.util;

import org.apache.commons.lang3.Validate;

public class VersionUtils {
    private static final String VERSION_SPLITTER = "\\.";

    public static boolean isGreaterThanOrEqualsTo(String currentVersion, String targetVersion) {
        return VersionUtils.compareVersions(currentVersion, targetVersion) >= 0;
    }

    public static boolean isGreaterThan(String currentVersion, String targetVersion) {
        return VersionUtils.compareVersions(currentVersion, targetVersion) > 0;
    }

    public static boolean isLessThanOrEqualsTo(String currentVersion, String targetVersion) {
        return !VersionUtils.isGreaterThan(currentVersion, targetVersion);
    }

    public static boolean isLessThan(String currentVersion, String targetVersion) {
        return !VersionUtils.isGreaterThanOrEqualsTo(currentVersion, targetVersion);
    }

    public static int compareVersions(String version1, String version2) {
        Validate.notEmpty((CharSequence)version1, (String)"parameter version1 may not be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)version2, (String)"parameter version2 may not be empty", (Object[])new Object[0]);
        String[] version1Parts = version1.split(VERSION_SPLITTER);
        String[] version2Parts = version2.split(VERSION_SPLITTER);
        int maxLength = Math.max(version1Parts.length, version2Parts.length);
        for (int i = 0; i < maxLength; ++i) {
            Integer version2Part;
            Integer version1Part = i < version1Parts.length ? Integer.parseInt(version1Parts[i]) : 0;
            int result = version1Part.compareTo(version2Part = Integer.valueOf(i < version2Parts.length ? Integer.parseInt(version2Parts[i]) : 0));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static class Version
    implements Comparable<Version> {
        private final String version;

        public Version(String version) {
            this.version = version;
        }

        @Override
        public int compareTo(Version o) {
            return VersionUtils.compareVersions(this.version, o.getVersion());
        }

        public String getVersion() {
            return this.version;
        }
    }
}

