/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.AbstractDBBrowserFactory;
import com.oceanbase.tools.dbbrowser.editor.DBObjectOperator;
import com.oceanbase.tools.dbbrowser.editor.mysql.MySQLObjectOperator;
import com.oceanbase.tools.dbbrowser.editor.oracle.OracleObjectOperator;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBObjectOperatorFactory
extends AbstractDBBrowserFactory<DBObjectOperator> {
    private DataSource dataSource;
    private JdbcOperations jdbcOperations;

    @Override
    public DBObjectOperator buildForDoris() {
        return this.buildForOBMySQL();
    }

    @Override
    public DBObjectOperator buildForMySQL() {
        return this.buildForOBMySQL();
    }

    @Override
    public DBObjectOperator buildForOBMySQL() {
        return new MySQLObjectOperator(this.getJdbcOperations());
    }

    @Override
    public DBObjectOperator buildForOBOracle() {
        return new OracleObjectOperator(this.getJdbcOperations());
    }

    @Override
    public DBObjectOperator buildForOracle() {
        return this.buildForOBOracle();
    }

    @Override
    public DBObjectOperator buildForOdpSharding() {
        return this.buildForOBMySQL();
    }

    @Override
    public DBObjectOperator buildForPostgres() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private JdbcOperations getJdbcOperations() {
        if (this.jdbcOperations != null) {
            return this.jdbcOperations;
        }
        if (this.dataSource != null) {
            return new JdbcTemplate(this.dataSource);
        }
        throw new IllegalArgumentException("Datasource can not be null");
    }

    public DBObjectOperatorFactory setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DBObjectOperatorFactory setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
        return this;
    }
}

