/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.editor.DBObjectEditor;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.datatype.DataTypeUtil;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;

public abstract class DBTableColumnEditor
implements DBObjectEditor<DBTableColumn> {
    @Override
    public boolean editable() {
        return true;
    }

    @Override
    public String generateCreateObjectDDL(@NotNull DBTableColumn column) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(column)).append(" ADD ");
        if (this.appendColumnKeyWord()) {
            sqlBuilder.append("COLUMN ");
        }
        this.appendColumnDefinition(column, sqlBuilder);
        sqlBuilder.append(";").line();
        this.generateColumnComment(column, sqlBuilder);
        String ddl = sqlBuilder.toString();
        if (!ddl.trim().endsWith(";")) {
            ddl = ddl + ";\n";
        }
        return ddl;
    }

    protected abstract boolean appendColumnKeyWord();

    protected void appendColumnDefinition(DBTableColumn column, SqlBuilder sqlBuilder) {
        sqlBuilder.identifier(column.getName());
        this.getSupportColumnModifiers().forEach(modifier -> modifier.appendModifier(column, sqlBuilder));
    }

    @Override
    public String generateCreateDefinitionDDL(@NotNull DBTableColumn column) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        this.appendColumnDefinition(column, sqlBuilder);
        return sqlBuilder.toString().trim();
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTableColumn oldColumn, @NotNull DBTableColumn newColumn) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(oldColumn)).append(" RENAME COLUMN ").identifier(oldColumn.getName()).append(" TO ").identifier(newColumn.getName());
        return sqlBuilder.toString();
    }

    @Override
    public String generateUpdateObjectDDL(@NotNull DBTableColumn oldColumn, @NotNull DBTableColumn newColumn) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (!StringUtils.equals((CharSequence)oldColumn.getName(), (CharSequence)newColumn.getName())) {
            sqlBuilder.append(this.generateRenameObjectDDL(oldColumn, newColumn)).append(";\n");
        }
        if (!Objects.equals(oldColumn, newColumn)) {
            sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(oldColumn)).append(" MODIFY ");
            if (this.appendColumnKeyWord()) {
                sqlBuilder.append("COLUMN ");
            }
            sqlBuilder.append(this.generateCreateDefinitionForUpdateDDL(oldColumn, newColumn)).append(";\n");
        }
        return sqlBuilder.toString();
    }

    @Override
    public String generateUpdateObjectListDDL(Collection<DBTableColumn> oldColumns, Collection<DBTableColumn> newColumns) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (CollectionUtils.isEmpty(oldColumns)) {
            if (CollectionUtils.isNotEmpty(newColumns)) {
                newColumns.forEach(column -> sqlBuilder.append(this.generateCreateObjectDDL((DBTableColumn)column)));
            }
            return sqlBuilder.toString();
        }
        if (CollectionUtils.isEmpty(newColumns)) {
            if (CollectionUtils.isNotEmpty(oldColumns)) {
                oldColumns.forEach(column -> sqlBuilder.append(this.generateDropObjectDDL((DBTableColumn)column)));
            }
            return sqlBuilder.toString();
        }
        HashMap position2OldColumn = new HashMap();
        HashMap position2NewColumn = new HashMap();
        oldColumns.forEach(oldColumn -> position2OldColumn.put(oldColumn.getOrdinalPosition(), oldColumn));
        newColumns.forEach(newColumn -> {
            if (Objects.nonNull(newColumn.getOrdinalPosition())) {
                position2NewColumn.put(newColumn.getOrdinalPosition(), newColumn);
            }
        });
        for (DBTableColumn newColumn2 : newColumns) {
            if (Objects.isNull(newColumn2.getOrdinalPosition())) {
                sqlBuilder.append(this.generateCreateObjectDDL(newColumn2));
                continue;
            }
            if (!position2OldColumn.containsKey(newColumn2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateUpdateObjectDDL((DBTableColumn)position2OldColumn.get(newColumn2.getOrdinalPosition()), newColumn2));
        }
        for (DBTableColumn oldColumn2 : oldColumns) {
            if (position2NewColumn.containsKey(oldColumn2.getOrdinalPosition())) continue;
            sqlBuilder.append(this.generateDropObjectDDL(oldColumn2));
        }
        return sqlBuilder.toString();
    }

    protected String generateCreateDefinitionForUpdateDDL(DBTableColumn oldColumn, DBTableColumn newColumn) {
        return this.generateCreateDefinitionDDL(newColumn);
    }

    protected abstract void generateColumnComment(DBTableColumn var1, SqlBuilder var2);

    @Override
    public String generateDropObjectDDL(@NotNull DBTableColumn column) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(column)).append(" DROP COLUMN ").identifier(column.getName()).append(";\n");
        return sqlBuilder.toString();
    }

    protected abstract SqlBuilder sqlBuilder();

    protected String getFullyQualifiedTableName(@NotNull DBTableColumn column) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        if (StringUtils.isNotEmpty((CharSequence)column.getSchemaName())) {
            sqlBuilder.identifier(column.getSchemaName()).append(".");
        }
        if (StringUtils.isNotEmpty((CharSequence)column.getTableName())) {
            sqlBuilder.identifier(column.getTableName());
        }
        return sqlBuilder.toString();
    }

    protected abstract List<DBColumnModifier> getSupportColumnModifiers();

    public static class NullNotNullModifier
    implements DBColumnModifier {
        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            sqlBuilder.append(column.getNullable() != false ? " NULL " : " NOT NULL");
        }
    }

    protected static interface DBColumnModifier {
        public void appendModifier(DBTableColumn var1, SqlBuilder var2);
    }

    public static class DataTypeModifier
    implements DBColumnModifier {
        @Override
        public void appendModifier(DBTableColumn column, SqlBuilder sqlBuilder) {
            String typeName = column.getTypeName();
            Long precision = column.getPrecision();
            Integer scale = column.getScale();
            sqlBuilder.space().append(typeName);
            if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"enum") || StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"set")) {
                if (CollectionUtils.isNotEmpty(column.getEnumValues())) {
                    List quotedValues = column.getEnumValues().stream().map(StringUtils::quoteMysqlValue).collect(Collectors.toList());
                    sqlBuilder.append("(").append(String.join((CharSequence)",", quotedValues)).append(")");
                }
                return;
            }
            if (Objects.isNull(scale)) {
                if (Objects.nonNull(precision)) {
                    sqlBuilder.append("(").append(String.valueOf(precision)).append(")");
                }
            } else if (Objects.isNull(precision)) {
                sqlBuilder.append("(").append(String.valueOf(scale)).append(")");
            } else {
                sqlBuilder.append("(").append(String.valueOf(precision)).append(", ").append(String.valueOf(scale)).append(")");
            }
            if (DataTypeUtil.isDateType(column.getTypeName()) && Objects.nonNull(column.getOnUpdateCurrentTimestamp()) && column.getOnUpdateCurrentTimestamp().booleanValue()) {
                sqlBuilder.append(" ON UPDATE CURRENT_TIMESTAMP");
                if (Objects.nonNull(precision)) {
                    sqlBuilder.append("(").append(String.valueOf(precision)).append(")");
                }
            }
            if (DataTypeUtil.isIntegerType(column.getTypeName()) && Objects.nonNull(column.getUnsigned())) {
                sqlBuilder.append(column.getUnsigned() != false ? " UNSIGNED " : "");
            }
            if (DataTypeUtil.isIntegerType(column.getTypeName()) && Objects.nonNull(column.getZerofill())) {
                sqlBuilder.append(column.getZerofill() != false ? " ZEROFILL " : "");
            }
        }
    }
}

