/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.AbstractDBBrowserFactory;
import com.oceanbase.tools.dbbrowser.editor.DBTableConstraintEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.MySQLConstraintEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.OBMySQLLessThan400ConstraintEditor;
import com.oceanbase.tools.dbbrowser.editor.oracle.OBOracleLessThan400ConstraintEditor;
import com.oceanbase.tools.dbbrowser.editor.oracle.OracleConstraintEditor;
import com.oceanbase.tools.dbbrowser.util.VersionUtils;
import org.apache.commons.lang3.Validate;

public class DBTableConstraintEditorFactory
extends AbstractDBBrowserFactory<DBTableConstraintEditor> {
    private String dbVersion;

    @Override
    public DBTableConstraintEditor buildForDoris() {
        return this.buildForMySQL();
    }

    @Override
    public DBTableConstraintEditor buildForMySQL() {
        return new MySQLConstraintEditor();
    }

    @Override
    public DBTableConstraintEditor buildForOBMySQL() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isLessThan(this.dbVersion, "4.0.0")) {
            return new OBMySQLLessThan400ConstraintEditor();
        }
        return new MySQLConstraintEditor();
    }

    @Override
    public DBTableConstraintEditor buildForOBOracle() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isLessThan(this.dbVersion, "4.0.0")) {
            return new OBOracleLessThan400ConstraintEditor();
        }
        return new OracleConstraintEditor();
    }

    @Override
    public DBTableConstraintEditor buildForOracle() {
        return new OracleConstraintEditor();
    }

    @Override
    public DBTableConstraintEditor buildForOdpSharding() {
        return this.buildForOBMySQL();
    }

    @Override
    public DBTableConstraintEditor buildForPostgres() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public DBTableConstraintEditorFactory setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
        return this;
    }
}

