/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor;

import com.oceanbase.tools.dbbrowser.AbstractDBBrowserFactory;
import com.oceanbase.tools.dbbrowser.editor.DBTableColumnEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTableColumnEditorFactory;
import com.oceanbase.tools.dbbrowser.editor.DBTableConstraintEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTableConstraintEditorFactory;
import com.oceanbase.tools.dbbrowser.editor.DBTableEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTableIndexEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTableIndexEditorFactory;
import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditorFactory;
import com.oceanbase.tools.dbbrowser.editor.mysql.MySQLTableEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.OBMySQLLessThan400TableEditor;
import com.oceanbase.tools.dbbrowser.editor.mysql.OBMySQLTableEditor;
import com.oceanbase.tools.dbbrowser.editor.oracle.OracleTableEditor;
import com.oceanbase.tools.dbbrowser.util.VersionUtils;
import org.apache.commons.lang3.Validate;

public class DBTableEditorFactory
extends AbstractDBBrowserFactory<DBTableEditor> {
    private String dbVersion;

    @Override
    public DBTableEditor buildForDoris() {
        return this.buildForMySQL();
    }

    @Override
    public DBTableEditor buildForMySQL() {
        return new MySQLTableEditor(this.getTableIndexEditor(), this.getTableColumnEditor(), this.getTableConstraintEditor(), this.getTablePartitionEditor());
    }

    @Override
    public DBTableEditor buildForOBMySQL() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        DBTableIndexEditor indexEditor = this.getTableIndexEditor();
        DBTableColumnEditor columnEditor = this.getTableColumnEditor();
        DBTableConstraintEditor constraintEditor = this.getTableConstraintEditor();
        DBTablePartitionEditor partitionEditor = this.getTablePartitionEditor();
        if (VersionUtils.isLessThan(this.dbVersion, "4.0.0")) {
            return new OBMySQLLessThan400TableEditor(indexEditor, columnEditor, constraintEditor, partitionEditor);
        }
        return new OBMySQLTableEditor(indexEditor, columnEditor, constraintEditor, partitionEditor);
    }

    @Override
    public DBTableEditor buildForOBOracle() {
        return new OracleTableEditor(this.getTableIndexEditor(), this.getTableColumnEditor(), this.getTableConstraintEditor(), this.getTablePartitionEditor());
    }

    @Override
    public DBTableEditor buildForOracle() {
        return this.buildForOBOracle();
    }

    @Override
    public DBTableEditor buildForOdpSharding() {
        return this.buildForOBMySQL();
    }

    @Override
    public DBTableEditor buildForPostgres() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private DBTableIndexEditor getTableIndexEditor() {
        DBTableIndexEditorFactory indexFactory = new DBTableIndexEditorFactory();
        indexFactory.setType(this.type);
        return (DBTableIndexEditor)indexFactory.create();
    }

    private DBTableColumnEditor getTableColumnEditor() {
        DBTableColumnEditorFactory columnFactory = new DBTableColumnEditorFactory();
        columnFactory.setType(this.type);
        return (DBTableColumnEditor)columnFactory.create();
    }

    private DBTablePartitionEditor getTablePartitionEditor() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        DBTablePartitionEditorFactory partitionFactory = new DBTablePartitionEditorFactory();
        partitionFactory.setType(this.type);
        partitionFactory.setDbVersion(this.dbVersion);
        return (DBTablePartitionEditor)partitionFactory.create();
    }

    private DBTableConstraintEditor getTableConstraintEditor() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        DBTableConstraintEditorFactory constraintFactory = new DBTableConstraintEditorFactory();
        constraintFactory.setType(this.type);
        constraintFactory.setDbVersion(this.dbVersion);
        return (DBTableConstraintEditor)constraintFactory.create();
    }

    public DBTableEditorFactory setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
        return this;
    }
}

