/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBTableConstraintEditor;
import com.oceanbase.tools.dbbrowser.model.DBConstraintDeferability;
import com.oceanbase.tools.dbbrowser.model.DBConstraintType;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class OracleConstraintEditor
extends DBTableConstraintEditor {
    @Override
    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }

    @Override
    public String generateRenameObjectDDL(@NotNull DBTableConstraint oldConstraint, @NotNull DBTableConstraint newConstraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        String drop = this.generateDropObjectDDL(oldConstraint);
        sqlBuilder.append(drop).append(this.generateCreateObjectDDL(newConstraint));
        return sqlBuilder.toString();
    }

    @Override
    public String generateDropObjectDDL(@NotNull DBTableConstraint constraint) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(constraint)).append(" DROP CONSTRAINT ").identifier(constraint.getName());
        return sqlBuilder.toString().trim() + ";\n";
    }

    @Override
    protected void appendConstraintOptions(DBTableConstraint constraint, SqlBuilder sqlBuilder) {
        super.appendConstraintOptions(constraint, sqlBuilder);
        if (Objects.nonNull((Object)constraint.getDeferability())) {
            if (constraint.getDeferability() == DBConstraintDeferability.INITIALLY_DEFERRED) {
                sqlBuilder.append(" DEFERRABLE INITIALLY DEFERRED");
            } else if (constraint.getDeferability() == DBConstraintDeferability.INITIALLY_IMMEDIATE) {
                sqlBuilder.append(" DEFERRABLE INITIALLY IMMEDIATE");
            }
        }
        if (Objects.nonNull(constraint.getEnabled()) && !constraint.getEnabled().booleanValue() && constraint.getType() == DBConstraintType.FOREIGN_KEY) {
            sqlBuilder.append(" DISABLE ");
        }
    }

    @Override
    protected String generateEnableOrDisableConstraintDDL(@NotNull DBTableConstraint newConstraint) {
        if (newConstraint.getType() != DBConstraintType.FOREIGN_KEY) {
            return "";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(newConstraint));
        if (newConstraint.getEnabled().booleanValue()) {
            sqlBuilder.append(" ENABLE CONSTRAINT ");
        } else {
            sqlBuilder.append(" DISABLE CONSTRAINT ");
        }
        sqlBuilder.identifier(newConstraint.getName()).append(";").line();
        return sqlBuilder.toString();
    }
}

