/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.editor.oracle;

import com.oceanbase.tools.dbbrowser.editor.DBTablePartitionEditor;
import com.oceanbase.tools.dbbrowser.model.DBTablePartition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionDefinition;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionOption;
import com.oceanbase.tools.dbbrowser.model.DBTablePartitionType;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.OracleSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.SqlBuilder;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class OracleDBTablePartitionEditor
extends DBTablePartitionEditor {
    @Override
    public String generateCreateObjectDDL(@NotNull DBTablePartition partition) {
        if (partition.getPartitionOption().getType() == DBTablePartitionType.NOT_PARTITIONED) {
            return "";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(this.getFullyQualifiedTableName(partition)).space().append("MODIFY").append(this.generateCreateDefinitionDDL(partition));
        return sqlBuilder.toString().trim() + ";\n";
    }

    @Override
    public String generateDropObjectDDL(DBTablePartition dbObject) {
        return "-- Unsupported operation to convert partitioned table to non-partitioned table\n";
    }

    @Override
    protected void appendDefinitions(DBTablePartition partition, SqlBuilder sqlBuilder) {
        DBTablePartitionType type = partition.getPartitionOption().getType();
        if (type == DBTablePartitionType.HASH && CollectionUtils.isEmpty(partition.getPartitionDefinitions())) {
            return;
        }
        sqlBuilder.append("(\n");
        boolean isFirstColumn = true;
        for (DBTablePartitionDefinition definition : partition.getPartitionDefinitions()) {
            if (!isFirstColumn) {
                sqlBuilder.append(",").line();
            }
            this.appendDefinition(partition.getPartitionOption(), definition, sqlBuilder);
            isFirstColumn = false;
        }
        sqlBuilder.append("\n)");
    }

    @Override
    protected void appendDefinition(DBTablePartitionOption option, DBTablePartitionDefinition definition, SqlBuilder sqlBuilder) {
        sqlBuilder.append("PARTITION ").identifier(definition.getName());
        if (option.getType() == DBTablePartitionType.RANGE && Objects.nonNull(definition.getMaxValues())) {
            sqlBuilder.append(" VALUES LESS THAN (").append(String.join((CharSequence)",", definition.getMaxValues())).append(")");
        } else if (option.getType() == DBTablePartitionType.LIST && Objects.nonNull(definition.getValuesList())) {
            sqlBuilder.append(" VALUES (").append(DBSchemaAccessorUtil.parseListRangeValuesList(definition.getValuesList())).append(")");
        }
    }

    @Override
    protected String modifyPartitionType(@NotNull DBTablePartition oldPartition, @NotNull DBTablePartition newPartition) {
        return "-- Unsupported operation to modify table partition type\n";
    }

    @Override
    public String generateAddPartitionDefinitionDDL(@NotNull DBTablePartitionDefinition definition, @NotNull DBTablePartitionOption option, String fullyQualifiedTableName) {
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ").append(fullyQualifiedTableName).append(" ADD ");
        this.appendDefinition(option, definition, sqlBuilder);
        sqlBuilder.append(";").line();
        return sqlBuilder.toString();
    }

    @Override
    public String generateAddPartitionDefinitionDDL(String schemaName, @NonNull String tableName, @NonNull DBTablePartitionOption option, List<DBTablePartitionDefinition> definitions) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        DBTablePartitionType partitionType = option.getType();
        if (partitionType != DBTablePartitionType.RANGE && partitionType != DBTablePartitionType.LIST) {
            return "-- Unsupported operation to modify table partition type\n";
        }
        SqlBuilder sqlBuilder = this.sqlBuilder();
        sqlBuilder.append("ALTER TABLE ");
        if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
            sqlBuilder.identifier(schemaName).append(".");
        }
        sqlBuilder.identifier(tableName).append(" ADD ").append("\n\t");
        Validate.isTrue((!CollectionUtils.isEmpty(definitions) ? 1 : 0) != 0, (String)"Partition elements can not be empty", (Object[])new Object[0]);
        for (int i = 0; i < definitions.size(); ++i) {
            this.appendDefinition(option, definitions.get(i), sqlBuilder);
            if (i >= definitions.size() - 1) continue;
            sqlBuilder.append(",\n\t");
        }
        return sqlBuilder.append(";").line().toString();
    }

    @Override
    protected SqlBuilder sqlBuilder() {
        return new OracleSqlBuilder();
    }
}

