/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.commons.lang3.StringUtils;

public enum DBColumnTypeDisplay {
    DISPLAY_PRECISION_AND_SCALE("decimal", "float", "double", "NUMBER"),
    DISPLAY_ONLY_PRECISION("bit", "int", "tinyint", "smallint", "mediumint", "bigint", "varchar", "char", "binary", "varbinary", "timestamp", "time", "datetime", "year", "INTEGER", "CHAR", "VARCHAR2", "RAW", "NCHAR", "VARCHAR", "NVARCHAR2", "FLOAT", "UROWID"),
    NOT_DISPLAY_PRECISION_AND_SCALE("boolean", "bool", "text", "tinytext", "mediumtext", "longtext", "tinyblob", "longblob", "mediumblob", "date", "BLOB", "CLOB", "DATE", "BINARY_FLOAT", "BINARY_DOUBLE", "ROWID", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE");

    private String[] typeNames;

    private DBColumnTypeDisplay(String ... typeNames) {
        this.typeNames = typeNames;
    }

    public boolean displayPrecision() {
        return this == DISPLAY_ONLY_PRECISION || this == DISPLAY_PRECISION_AND_SCALE;
    }

    public boolean displayScale() {
        return this == DISPLAY_PRECISION_AND_SCALE;
    }

    @JsonCreator
    public static DBColumnTypeDisplay fromName(String name) {
        for (DBColumnTypeDisplay type : DBColumnTypeDisplay.values()) {
            for (String singleValue : type.typeNames) {
                if (!StringUtils.equals((CharSequence)singleValue, (CharSequence)name)) continue;
                return type;
            }
        }
        return NOT_DISPLAY_PRECISION_AND_SCALE;
    }
}

