/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.model.datatype;

import com.oceanbase.tools.dbbrowser.model.datatype.DataType;
import com.oceanbase.tools.dbbrowser.model.datatype.DataTypeFactory;
import com.oceanbase.tools.dbbrowser.model.datatype.GeneralDataType;
import com.oceanbase.tools.dbbrowser.model.datatype.parser.DataTypeParser;
import com.oceanbase.tools.dbbrowser.model.datatype.parser.DataTypeToken;
import com.oceanbase.tools.dbbrowser.model.datatype.parser.DefaultDataTypeTokenVisitor;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDataTypeFactory
extends DefaultDataTypeTokenVisitor
implements DataTypeFactory {
    private static final Logger log = LoggerFactory.getLogger(CommonDataTypeFactory.class);
    private final List<String> dataTypeNames = new LinkedList<String>();
    private final List<Integer> scales = new LinkedList<Integer>();
    private Integer bracketCounter = 0;

    public CommonDataTypeFactory(@NonNull String dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DataTypeParser parser = new DataTypeParser(DataTypeParser.getTokens(dataType));
        parser.parse(this);
    }

    @Override
    public DataType generate() {
        String dataTypeName = String.join((CharSequence)" ", this.dataTypeNames);
        if (this.scales.size() == 0) {
            return new GeneralDataType(dataTypeName);
        }
        if (this.scales.size() == 1) {
            return new GeneralDataType(this.scales.get(0), dataTypeName);
        }
        return new GeneralDataType(this.scales.get(0), this.scales.get(1), dataTypeName);
    }

    @Override
    public void visitName(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (this.bracketCounter <= 0) {
            this.dataTypeNames.add(token.getText());
        }
    }

    @Override
    public void visitNumber(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        try {
            this.scales.add(Integer.parseInt(token.getText()));
        }
        catch (Exception e) {
            log.warn("Failed to parse integer, token={}", (Object)token, (Object)e);
        }
    }

    @Override
    public void visitBrackets(@NonNull DataTypeToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if ("(".equals(token.getText())) {
            Integer n = this.bracketCounter;
            Integer n2 = this.bracketCounter = Integer.valueOf(this.bracketCounter + 1);
        } else if (")".equals(token.getText())) {
            Integer n = this.bracketCounter;
            Integer n3 = this.bracketCounter = Integer.valueOf(this.bracketCounter - 1);
        }
    }
}

