/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.parser;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.oceanbase.tools.dbbrowser.parser.CacheElement;
import com.oceanbase.tools.dbbrowser.parser.listener.CustomErrorListener;
import com.oceanbase.tools.dbbrowser.parser.listener.MysqlModeSqlParserListener;
import com.oceanbase.tools.dbbrowser.parser.listener.OracleModeSqlParserListener;
import com.oceanbase.tools.dbbrowser.parser.result.ParseSqlResult;
import com.oceanbase.tools.sqlparser.OBMySQLParser;
import com.oceanbase.tools.sqlparser.OBOracleSQLParser;
import com.oceanbase.tools.sqlparser.oboracle.OBLexer;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.statement.Statement;
import com.oceanbase.tools.sqlparser.util.TimeoutTokenStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParser {
    private static final Logger log = LoggerFactory.getLogger(SqlParser.class);
    private static final Cache<String, CacheElement<ParseSqlResult>> OB_MYSQL_PARSE_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static final Cache<String, CacheElement<ParseSqlResult>> OB_ORACLE_PARSE_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static final Cache<String, CacheElement<Statement>> OB_MYSQL_STMT_PARSE_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static final Cache<String, CacheElement<Statement>> OB_ORACLE_STMT_PARSE_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public static Statement parseMysqlStatement(@NonNull String sql) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        CacheElement value = (CacheElement)OB_MYSQL_STMT_PARSE_CACHE.get((Object)sql, s -> {
            try {
                return new CacheElement<Statement>(new OBMySQLParser().parse((Reader)new StringReader(sql)));
            }
            catch (Exception e) {
                return new CacheElement(e);
            }
        });
        return value == null ? null : (Statement)value.get();
    }

    public static Statement parseOracleStatement(@NonNull String sql) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        CacheElement value = (CacheElement)OB_ORACLE_STMT_PARSE_CACHE.get((Object)sql, s -> {
            try {
                return new CacheElement<Statement>(new OBOracleSQLParser().parse((Reader)new StringReader(sql)));
            }
            catch (Exception e) {
                return new CacheElement(e);
            }
        });
        return value == null ? null : (Statement)value.get();
    }

    public static ParseSqlResult parseMysql(String sql) {
        return SqlParser.parseMysql(sql, 0L);
    }

    public static ParseSqlResult parseMysql(String sql, long timeoutMillis) {
        CacheElement value = (CacheElement)OB_MYSQL_PARSE_CACHE.get((Object)sql, s -> {
            try {
                return new CacheElement<ParseSqlResult>(SqlParser.doParseMysql(sql, timeoutMillis));
            }
            catch (Exception e) {
                return new CacheElement(e);
            }
        });
        return value == null ? null : (ParseSqlResult)value.get();
    }

    private static ParseSqlResult doParseMysql(String sql, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        CodePointCharStream input = CharStreams.fromString((String)sql);
        com.oceanbase.tools.sqlparser.obmysql.OBLexer lexer = new com.oceanbase.tools.sqlparser.obmysql.OBLexer((CharStream)input);
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        com.oceanbase.tools.sqlparser.obmysql.OBParser parser = new com.oceanbase.tools.sqlparser.obmysql.OBParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new CustomErrorListener());
        log.info("Time cost for sql parsing is {}ms, sql={}", (Object)(System.currentTimeMillis() - startTime), (Object)sql);
        return SqlParser.parseMysql((ParseTree)parser.stmt());
    }

    public static ParseSqlResult parseMysql(@NonNull ParseTree parseTree) {
        if (parseTree == null) {
            throw new NullPointerException("parseTree is marked non-null but is null");
        }
        MysqlModeSqlParserListener listener = new MysqlModeSqlParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, parseTree);
        return new ParseSqlResult(listener);
    }

    public static ParseSqlResult parseOracle(String sql) {
        return SqlParser.parseOracle(sql, 0L);
    }

    public static ParseSqlResult parseOracle(String sql, long timeoutMillis) {
        CacheElement value = (CacheElement)OB_ORACLE_PARSE_CACHE.get((Object)sql, s -> {
            try {
                return new CacheElement<ParseSqlResult>(SqlParser.doParseOracle(sql, timeoutMillis));
            }
            catch (Exception e) {
                return new CacheElement(e);
            }
        });
        return value == null ? null : (ParseSqlResult)value.get();
    }

    private static ParseSqlResult doParseOracle(String sql, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        CodePointCharStream input = CharStreams.fromString((String)sql);
        OBLexer lexer = new OBLexer((CharStream)input);
        Object tokens = timeoutMillis <= 0L ? new CommonTokenStream((TokenSource)lexer) : new TimeoutTokenStream((TokenSource)lexer, timeoutMillis);
        OBParser parser = new OBParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new CustomErrorListener());
        log.info("Time cost for sql parsing is {}ms, sql={}", (Object)(System.currentTimeMillis() - startTime), (Object)sql);
        return SqlParser.parseOracle((ParseTree)parser.stmt());
    }

    public static ParseSqlResult parseOracle(@NonNull ParseTree parseTree) {
        if (parseTree == null) {
            throw new NullPointerException("parseTree is marked non-null but is null");
        }
        OracleModeSqlParserListener listener = new OracleModeSqlParserListener();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, parseTree);
        return new ParseSqlResult(listener);
    }
}

