/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema;

import com.oceanbase.tools.dbbrowser.AbstractDBBrowserFactory;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.doris.DorisSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.MySQLNoLessThan5600SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.MySQLNoLessThan5700SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLBetween220And225XSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLBetween2260And2276SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLBetween2277And3XSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLNoGreaterThan1479SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.OBMySQLSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.mysql.ODPOBMySQLSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.oracle.OBOracleBetween4000And4100SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.oracle.OBOracleLessThan2270SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.oracle.OBOracleLessThan400SchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.oracle.OBOracleSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.oracle.OracleSchemaAccessor;
import com.oceanbase.tools.dbbrowser.schema.postgre.PostgresSchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.ALLDataDictTableNames;
import com.oceanbase.tools.dbbrowser.util.VersionUtils;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBSchemaAccessorFactory
extends AbstractDBBrowserFactory<DBSchemaAccessor> {
    public static final String TENANT_NAME_KEY = "tenantName";
    public static final String SYS_OPERATIONS_KEY = "sysOperations";
    private String dbVersion;
    private DataSource dataSource;
    private JdbcOperations jdbcOperations;
    private Map<String, Object> properties;

    @Override
    public DBSchemaAccessor buildForMySQL() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "5.7.0")) {
            return new MySQLNoLessThan5700SchemaAccessor(this.getJdbcOperations());
        }
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "5.6.0")) {
            return new MySQLNoLessThan5600SchemaAccessor(this.getJdbcOperations());
        }
        throw new UnsupportedOperationException(String.format("MySQL version '%s' not supported", this.dbVersion));
    }

    @Override
    public DBSchemaAccessor buildForOBMySQL() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "4.0.0")) {
            return new OBMySQLSchemaAccessor(this.getJdbcOperations());
        }
        if (VersionUtils.isGreaterThan(this.dbVersion, "2.2.76")) {
            return new OBMySQLBetween2277And3XSchemaAccessor(this.getJdbcOperations());
        }
        if (VersionUtils.isGreaterThan(this.dbVersion, "2.2.60")) {
            return new OBMySQLBetween2260And2276SchemaAccessor(this.getJdbcOperations());
        }
        if (VersionUtils.isGreaterThan(this.dbVersion, "1.4.79")) {
            return new OBMySQLBetween220And225XSchemaAccessor(this.getJdbcOperations());
        }
        String tenantName = null;
        JdbcOperations sysJdbcOperations = null;
        if (this.properties != null) {
            Object value = this.properties.get(TENANT_NAME_KEY);
            if (value instanceof String) {
                tenantName = (String)value;
            }
            if ((value = this.properties.get(SYS_OPERATIONS_KEY)) instanceof JdbcOperations) {
                sysJdbcOperations = (JdbcOperations)value;
            }
        }
        return new OBMySQLNoGreaterThan1479SchemaAccessor(this.getJdbcOperations(), sysJdbcOperations, tenantName);
    }

    @Override
    public DBSchemaAccessor buildForOBOracle() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "4.1.0")) {
            return new OBOracleSchemaAccessor(this.getJdbcOperations(), new ALLDataDictTableNames());
        }
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "4.0.0")) {
            return new OBOracleBetween4000And4100SchemaAccessor(this.getJdbcOperations(), new ALLDataDictTableNames());
        }
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "2.2.70")) {
            return new OBOracleLessThan400SchemaAccessor(this.getJdbcOperations(), new ALLDataDictTableNames());
        }
        return new OBOracleLessThan2270SchemaAccessor(this.getJdbcOperations(), new ALLDataDictTableNames());
    }

    @Override
    public DBSchemaAccessor buildForOracle() {
        return new OracleSchemaAccessor(this.getJdbcOperations(), new ALLDataDictTableNames());
    }

    @Override
    public DBSchemaAccessor buildForOdpSharding() {
        return new ODPOBMySQLSchemaAccessor(this.getJdbcOperations());
    }

    @Override
    public DBSchemaAccessor buildForDoris() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "5.7.0")) {
            return new DorisSchemaAccessor(this.getJdbcOperations());
        }
        throw new UnsupportedOperationException(String.format("Doris version '%s' not supported", this.dbVersion));
    }

    @Override
    public DBSchemaAccessor buildForPostgres() {
        return new PostgresSchemaAccessor(this.getJdbcOperations());
    }

    private JdbcOperations getJdbcOperations() {
        if (this.jdbcOperations != null) {
            return this.jdbcOperations;
        }
        if (this.dataSource != null) {
            return new JdbcTemplate(this.dataSource);
        }
        throw new IllegalArgumentException("Datasource can not be null");
    }

    public DBSchemaAccessorFactory setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
        return this;
    }

    public DBSchemaAccessorFactory setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DBSchemaAccessorFactory setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
        return this;
    }

    public DBSchemaAccessorFactory setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }
}

