/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.schema.mysql;

import com.oceanbase.tools.dbbrowser.model.DBColumnGroupElement;
import com.oceanbase.tools.dbbrowser.model.DBDatabase;
import com.oceanbase.tools.dbbrowser.model.DBIndexAlgorithm;
import com.oceanbase.tools.dbbrowser.model.DBObjectIdentity;
import com.oceanbase.tools.dbbrowser.model.DBObjectType;
import com.oceanbase.tools.dbbrowser.model.DBObjectWarningDescriptor;
import com.oceanbase.tools.dbbrowser.model.DBTable;
import com.oceanbase.tools.dbbrowser.model.DBTableColumn;
import com.oceanbase.tools.dbbrowser.model.DBTableConstraint;
import com.oceanbase.tools.dbbrowser.model.DBTableIndex;
import com.oceanbase.tools.dbbrowser.parser.SqlParser;
import com.oceanbase.tools.dbbrowser.parser.result.ParseSqlResult;
import com.oceanbase.tools.dbbrowser.schema.DBSchemaAccessorSqlMappers;
import com.oceanbase.tools.dbbrowser.schema.mysql.MySQLNoLessThan5700SchemaAccessor;
import com.oceanbase.tools.dbbrowser.util.DBSchemaAccessorUtil;
import com.oceanbase.tools.dbbrowser.util.MySQLSqlBuilder;
import com.oceanbase.tools.dbbrowser.util.StringUtils;
import com.oceanbase.tools.sqlparser.statement.Statement;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;

public class OBMySQLSchemaAccessor
extends MySQLNoLessThan5700SchemaAccessor {
    private static final Logger log = LoggerFactory.getLogger(OBMySQLSchemaAccessor.class);
    protected static final Set<String> ESCAPE_SCHEMA_SET = new HashSet<String>(3);

    @Override
    public List<String> showDatabases() {
        return super.showDatabases().stream().filter(database -> !ESCAPE_SCHEMA_SET.contains(database)).collect(Collectors.toList());
    }

    public OBMySQLSchemaAccessor(JdbcOperations jdbcOperations) {
        super(jdbcOperations);
        this.sqlMapper = DBSchemaAccessorSqlMappers.get("schema/sql/obmysql/obmysql_4_0_x.yaml");
    }

    @Override
    public DBDatabase getDatabase(String schemaName) {
        DBDatabase database = new DBDatabase();
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("select object_name, timestamp from oceanbase.DBA_OBJECTS where object_type = 'DATABASE' and object_name = ").value(schemaName);
        this.jdbcOperations.query(sb.toString(), rs -> {
            String objectName = rs.getString("object_name");
            String timestamp = rs.getString("timestamp");
            database.setName(objectName);
            database.setId(objectName + "_" + timestamp);
        });
        String sql = "SELECT DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME FROM information_schema.schemata where SCHEMA_NAME ='" + schemaName + "'";
        this.jdbcOperations.query(sql, rs -> {
            database.setCharset(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
            database.setCollation(rs.getString("DEFAULT_COLLATION_NAME"));
        });
        return database;
    }

    @Override
    public List<DBObjectIdentity> listTables(String schemaName, String tableNameLike) {
        List<DBObjectIdentity> results = super.listTables(schemaName, tableNameLike);
        if (StringUtils.isBlank((CharSequence)schemaName) || "oceanbase".equals(schemaName)) {
            MySQLSqlBuilder querySystemTable = new MySQLSqlBuilder();
            querySystemTable.append("show full tables from oceanbase where Table_type='BASE TABLE'");
            if (StringUtils.isNotBlank((CharSequence)tableNameLike)) {
                querySystemTable.append(" and tables_in_oceanbase like ").value("%" + tableNameLike + "%");
            }
            try {
                List tables = this.jdbcOperations.query(querySystemTable.toString(), (rs, rowNum) -> rs.getString(1));
                tables.forEach(name -> results.add(DBObjectIdentity.of("oceanbase", DBObjectType.TABLE, name)));
            }
            catch (Exception e) {
                log.warn("List system tables from 'oceanbase' failed, reason={}", (Object)e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)schemaName) || "mysql".equals(schemaName)) {
            MySQLSqlBuilder queryMysqlTable = new MySQLSqlBuilder();
            queryMysqlTable.append("show full tables from `mysql` where Table_type='BASE TABLE'");
            if (StringUtils.isNotBlank((CharSequence)tableNameLike)) {
                queryMysqlTable.append(" and tables_in_mysql like ").value("%" + tableNameLike + "%");
            }
            try {
                this.jdbcOperations.query(queryMysqlTable.toString(), (rs, num) -> results.add(DBObjectIdentity.of("mysql", DBObjectType.TABLE, rs.getString(1))));
            }
            catch (Exception e) {
                log.warn("List base tables from 'mysql' failed, reason={}", (Object)e.getMessage());
            }
        }
        return results;
    }

    @Override
    public List<DBObjectIdentity> listAllSystemViews() {
        List<DBObjectIdentity> results = super.listAllSystemViews();
        String sql1 = "show full tables from `oceanbase` where Table_type='SYSTEM VIEW'";
        try {
            List oceanbaseViews = this.jdbcOperations.query(sql1, (rs, rowNum) -> rs.getString(1));
            oceanbaseViews.forEach(name -> results.add(DBObjectIdentity.of("oceanbase", DBObjectType.VIEW, name)));
        }
        catch (Exception ex) {
            log.info("List tables for 'oceanbase' failed, reason={}", (Object)ex.getMessage());
        }
        return results;
    }

    @Override
    public List<DBTableColumn> listTableColumns(String schemaName, String tableName) {
        List<DBTableColumn> columns = super.listTableColumns(schemaName, tableName);
        this.setStoredColumnByDDL(schemaName, tableName, columns);
        return columns;
    }

    protected void setStoredColumnByDDL(String schemeName, String tableName, List<DBTableColumn> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return;
        }
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("show create table ");
            sb.schemaPrefixIfNotBlank(schemeName);
            sb.identifier(tableName);
            List ddl = this.jdbcOperations.query(sb.toString(), (rs, num) -> rs.getString(2));
            if (CollectionUtils.isEmpty((Collection)ddl) || StringUtils.isBlank((CharSequence)((CharSequence)ddl.get(0)))) {
                this.fillWarning(columns, DBObjectType.COLUMN, "get table DDL failed");
            } else {
                ParseSqlResult result = SqlParser.parseMysql((String)ddl.get(0));
                if (CollectionUtils.isEmpty(result.getColumns())) {
                    this.fillWarning(columns, DBObjectType.COLUMN, "parse DDL failed, may view object");
                } else {
                    columns.forEach(column -> result.getColumns().forEach(columnDefinition -> {
                        if (StringUtils.equals((CharSequence)column.getName(), (CharSequence)columnDefinition.getName())) {
                            column.setStored(columnDefinition.getIsStored());
                        }
                    }));
                }
            }
        }
        catch (Exception e) {
            this.fillWarning(columns, DBObjectType.COLUMN, "query ddl failed");
            log.warn("Fetch table ddl for parsing column failed", (Throwable)e);
        }
    }

    @Override
    public List<DBTableIndex> listTableIndexes(String schemaName, String tableName) {
        List<DBTableIndex> indexList = super.listTableIndexes(schemaName, tableName);
        this.fillIndexInfo(indexList, schemaName, tableName);
        for (DBTableIndex index : indexList) {
            if (index.getAlgorithm() != DBIndexAlgorithm.UNKNOWN) continue;
            index.setAlgorithm(DBIndexAlgorithm.BTREE);
        }
        return indexList;
    }

    @Override
    protected void handleIndexAvailability(DBTableIndex index, String availability) {
        if ("available".equals(availability)) {
            index.setAvailable(true);
        } else if ("unavailable".equals(availability)) {
            index.setAvailable(false);
        }
    }

    @Override
    public Map<String, List<DBTableIndex>> listTableIndexes(String schemaName) {
        Map<String, List<DBTableIndex>> tableName2Indexes = super.listTableIndexes(schemaName);
        for (Map.Entry<String, List<DBTableIndex>> entry : tableName2Indexes.entrySet()) {
            this.fillIndexInfo(entry.getValue(), schemaName, entry.getKey());
            for (DBTableIndex index : entry.getValue()) {
                if (index.getAlgorithm() != DBIndexAlgorithm.UNKNOWN) continue;
                index.setAlgorithm(DBIndexAlgorithm.BTREE);
            }
        }
        return tableName2Indexes;
    }

    public Map<String, List<DBTableIndex>> listTableIndexes(String schemaName, Map<String, String> tableName2Ddl) {
        Map<String, List<DBTableIndex>> tableName2Indexes = super.listTableIndexes(schemaName);
        tableName2Indexes.keySet().forEach(tableName -> {
            if (tableName2Ddl.containsKey(tableName)) {
                this.parseDdlToSetIndexInfo((String)tableName2Ddl.get(tableName), (List)tableName2Indexes.get(tableName));
            } else {
                this.fillIndexInfo((List)tableName2Indexes.get(tableName), schemaName, (String)tableName);
            }
        });
        return tableName2Indexes;
    }

    @Override
    public List<DBColumnGroupElement> listTableColumnGroups(String schemaName, String tableName) {
        return this.listTableColumnGroups(this.getTableDDL(schemaName, tableName));
    }

    private List<DBColumnGroupElement> listTableColumnGroups(String ddl) {
        Statement statement = SqlParser.parseMysqlStatement(ddl);
        if (statement instanceof CreateTable) {
            CreateTable stmt = (CreateTable)statement;
            return stmt.getColumnGroupElements() == null ? Collections.emptyList() : stmt.getColumnGroupElements().stream().map(DBColumnGroupElement::ofColumnGroupElement).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isIndexDistinguishesVisibility() {
        return true;
    }

    protected void fillIndexInfo(List<DBTableIndex> indexList, String schemaName, String tableName) {
        this.setIndexInfoByDDL(indexList, schemaName, tableName);
    }

    protected void setIndexInfoByDDL(List<DBTableIndex> indexList, String schemaName, String tableName) {
        try {
            MySQLSqlBuilder sb = new MySQLSqlBuilder();
            sb.append("show create table ");
            sb.identifier(schemaName, tableName);
            List ddl = this.jdbcOperations.query(sb.toString(), (rs, num) -> rs.getString(2));
            if (CollectionUtils.isEmpty((Collection)ddl) || StringUtils.isBlank((CharSequence)((CharSequence)ddl.get(0)))) {
                this.fillWarning(indexList, DBObjectType.INDEX, "get index DDL failed");
            } else {
                this.parseDdlToSetIndexInfo((String)ddl.get(0), indexList);
            }
        }
        catch (Exception e) {
            this.fillWarning(indexList, DBObjectType.INDEX, "query index ddl failed");
            log.warn("Fetch table index through ddl parsing failed", (Throwable)e);
        }
    }

    private void parseDdlToSetIndexInfo(String ddl, List<DBTableIndex> indexList) {
        if (StringUtils.isBlank((CharSequence)ddl)) {
            this.fillWarning(indexList, DBObjectType.INDEX, "table ddl is blank, can not set index range by parse ddl");
            return;
        }
        ParseSqlResult result = SqlParser.parseMysql(ddl);
        if (CollectionUtils.isEmpty(result.getIndexes())) {
            this.fillWarning(indexList, DBObjectType.INDEX, "parse index DDL failed");
        } else {
            indexList.forEach(index -> result.getIndexes().forEach(dbIndex -> {
                if (StringUtils.equals((CharSequence)index.getName(), (CharSequence)dbIndex.getName())) {
                    index.setGlobal("GLOBAL".equalsIgnoreCase(dbIndex.getRange().name()));
                    index.setColumnGroups(dbIndex.getColumnGroups());
                }
            }));
        }
    }

    protected <T extends DBObjectWarningDescriptor> void fillWarning(List<T> warningDescriptor, DBObjectType type, String reason) {
        if (CollectionUtils.isEmpty(warningDescriptor)) {
            return;
        }
        warningDescriptor.forEach(descriptor -> {
            if (StringUtils.isBlank((CharSequence)descriptor.getWarning())) {
                DBSchemaAccessorUtil.fillWarning(descriptor, type, reason);
            }
        });
    }

    @Override
    public List<DBObjectIdentity> listSequences(String schemaName) {
        MySQLSqlBuilder sb = new MySQLSqlBuilder();
        sb.append("SHOW SEQUENCES IN ").identifier(schemaName);
        List sequenceNames = this.jdbcOperations.queryForList(sb.toString(), String.class);
        return sequenceNames.stream().map(name -> DBObjectIdentity.of(schemaName, DBObjectType.SEQUENCE, name)).collect(Collectors.toList());
    }

    @Override
    public Map<String, DBTable> getTables(@NonNull String schemaName, List<String> tableNames) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        HashMap<String, DBTable> returnVal = new HashMap<String, DBTable>();
        tableNames = this.showTables(schemaName);
        if (tableNames.isEmpty()) {
            return returnVal;
        }
        HashMap<String, String> tableName2Ddl = new HashMap<String, String>();
        tableNames.stream().forEach(tableName -> tableName2Ddl.put((String)tableName, this.getTableDDL(schemaName, (String)tableName)));
        Map<String, List<DBTableColumn>> tableName2Columns = this.listTableColumns(schemaName, Collections.emptyList());
        Map<String, List<DBTableIndex>> tableName2Indexes = this.listTableIndexes(schemaName, tableName2Ddl);
        Map<String, List<DBTableConstraint>> tableName2Constraints = this.listTableConstraints(schemaName);
        Map<String, DBTable.DBTableOptions> tableName2Options = this.listTableOptions(schemaName);
        for (String tableName2 : tableNames) {
            if (!tableName2Columns.containsKey(tableName2)) continue;
            DBTable table = new DBTable();
            table.setSchemaName(schemaName);
            table.setOwner(schemaName);
            table.setName(tableName2);
            table.setColumns(tableName2Columns.getOrDefault(tableName2, new ArrayList()));
            table.setIndexes(tableName2Indexes.getOrDefault(tableName2, new ArrayList()));
            table.setConstraints(tableName2Constraints.getOrDefault(tableName2, new ArrayList()));
            table.setTableOptions(tableName2Options.getOrDefault(tableName2, new DBTable.DBTableOptions()));
            table.setColumnGroups(this.listTableColumnGroups((String)tableName2Ddl.get(tableName2)));
            try {
                table.setPartition(this.getPartition(schemaName, tableName2));
            }
            catch (Exception e) {
                log.warn("Failed to set table partition", (Throwable)e);
            }
            table.setDDL((String)tableName2Ddl.get(tableName2));
            returnVal.put(tableName2, table);
        }
        return returnVal;
    }

    @Override
    protected void correctColumnPrecisionIfNeed(List<DBTableColumn> tableColumns) {
    }

    static {
        ESCAPE_SCHEMA_SET.add("PUBLIC");
        ESCAPE_SCHEMA_SET.add("LBACSYS");
        ESCAPE_SCHEMA_SET.add("ORAAUDITOR");
        ESCAPE_SCHEMA_SET.add("__public");
    }
}

