/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.dbbrowser.stats;

import com.oceanbase.tools.dbbrowser.AbstractDBBrowserFactory;
import com.oceanbase.tools.dbbrowser.stats.DBStatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.mysql.DorisStatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.mysql.MySQLNoLessThan5700StatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.mysql.OBMySQLNoLessThan400StatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.mysql.OBMySQLStatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.mysql.ODPOBMySQLStatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.oracle.OBOracleLessThan2270StatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.oracle.OBOracleNoLessThan2270StatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.oracle.OBOracleNoLessThan400StatsAccessor;
import com.oceanbase.tools.dbbrowser.stats.oracle.OracleStatsAccessor;
import com.oceanbase.tools.dbbrowser.util.VersionUtils;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBStatsAccessorFactory
extends AbstractDBBrowserFactory<DBStatsAccessor> {
    public static final String CONNECTION_ID_KEY = "connectionId";
    private String dbVersion;
    private DataSource dataSource;
    private JdbcOperations jdbcOperations;
    private Map<String, Object> properties;

    @Override
    public DBStatsAccessor buildForDoris() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "5.7.0")) {
            return new DorisStatsAccessor(this.getJdbcOperations());
        }
        throw new UnsupportedOperationException(String.format("Doris version '%s' not supported", this.dbVersion));
    }

    @Override
    public DBStatsAccessor buildForMySQL() {
        return new MySQLNoLessThan5700StatsAccessor(this.getJdbcOperations());
    }

    @Override
    public DBStatsAccessor buildForOBMySQL() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "4.0.0")) {
            return new OBMySQLNoLessThan400StatsAccessor(this.getJdbcOperations());
        }
        return new OBMySQLStatsAccessor(this.getJdbcOperations());
    }

    @Override
    public DBStatsAccessor buildForOBOracle() {
        Validate.notNull((Object)this.dbVersion, (String)"DBVersion can not be null", (Object[])new Object[0]);
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "4.0.0")) {
            return new OBOracleNoLessThan400StatsAccessor(this.getJdbcOperations());
        }
        if (VersionUtils.isGreaterThanOrEqualsTo(this.dbVersion, "2.2.70")) {
            return new OBOracleNoLessThan2270StatsAccessor(this.getJdbcOperations());
        }
        return new OBOracleLessThan2270StatsAccessor(this.getJdbcOperations());
    }

    @Override
    public DBStatsAccessor buildForOracle() {
        return new OracleStatsAccessor(this.getJdbcOperations());
    }

    @Override
    public DBStatsAccessor buildForOdpSharding() {
        Object value;
        String connectionId = null;
        if (this.properties != null && (value = this.properties.get(CONNECTION_ID_KEY)) instanceof String) {
            connectionId = (String)value;
        }
        return new ODPOBMySQLStatsAccessor(connectionId);
    }

    @Override
    public DBStatsAccessor buildForPostgres() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private JdbcOperations getJdbcOperations() {
        if (this.jdbcOperations != null) {
            return this.jdbcOperations;
        }
        if (this.dataSource != null) {
            return new JdbcTemplate(this.dataSource);
        }
        throw new IllegalArgumentException("Datasource can not be null");
    }

    public DBStatsAccessorFactory setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
        return this;
    }

    public DBStatsAccessorFactory setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DBStatsAccessorFactory setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
        return this;
    }

    public DBStatsAccessorFactory setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }
}

